#ifndef File_hpp
#define File_hpp

#include <string>

using namespace std;

// class File
// 
// is an abstract class that may be extended to system-specific subclasses,
// to which this class provides an interface to.
// 
// Every object represents a file.
// 
// Functions:
//  * quering name and path to the file.
//  * quering its size
//  * quering file 'type' (directory, regular file)

class File {
  public:
          virtual    ~File() {};

          virtual    bool exists()  const =0;
          
                                              // high level enquery mehtods
          virtual    bool isNavigable()  const =0;
          
                                              // low level enquery methods
          virtual    bool isDirectory()  const =0;
          virtual    bool isFile()  const =0;
          
          virtual    string getName()  const =0;
          virtual    string getParent()  const =0;
          virtual    string getFullName()  const =0;
          virtual    long int getSize()  const =0;
};



#endif
