#include <stdlib.h>

#include "Date.hpp"
//#include <stdio.h>

 
Date::Date() {
  t= time( 0);  // Betriebssystem-Aufruf
}

Date::Date( time_type t) {
  this->t= t;
}

Date::~Date() { };

time_type Date::getTimeValue() const {
  return this->t;
}

void Date::add( Date& diff) {
  t += diff.t;
}

void Date::sub( Date& diff) {
  t -= diff.t;
}

Date Date::difference( Date& d2, Date& d1) {
  Date d( d2.t - d1.t);
  return d;
}

string Date::toDateString( TimeZone& tz) {
  time_type t= this->t;
                              //  time zone corrections
  t+= tz.getTimeValue();
  
  tm* pzeit;
  pzeit= gmtime( &t);

  char str[80];
  char format[]= "%Y-%m-%d";
  strftime( str, 80, format, pzeit);
  string s( str);
  return s;
}

string Date::toTimeString( TimeZone& tz) {
  time_type t= this->t;
  
                            // time zone corrections 
  t+= tz.getTimeValue();
  
  
  tm* pzeit;
  pzeit= gmtime( &t);

  char str[80];
  char format[]= "%H:%M:%S";
  strftime( str, 80, format, pzeit);
  string s( str);
  return s;
}


string Date::toString() const {
  time_type t= this->t;
  
  tm* pzeit= localtime( &t);

  char str[80];
  char format[]= "%Y-%m-%d %H:%M:%S %Z";
  strftime( str, 80, format, pzeit);
  string s( str); 
  return s;
} 

string Date::toString( const TimeZone& tz) const {
  return toString( "%Y-%m-%d %H:%M:%S", tz);
}

string Date::toString( const string& formatString) const {
  time_type t= this->t;
  
  tm* pzeit= localtime( &t);

  char str[80];
  const char* format= formatString.c_str();
  strftime( str, 80, format, pzeit);
  string s( str);
  return s;
}  

string Date::toString( const string& formatString, const TimeZone& tz)  const {
  time_type t= this->t;
  t += tz.t;
  tm* pzeit= gmtime( &t);

  char str[80];
  const char* format= formatString.c_str();
  strftime( str, 80, format, pzeit);
  string s( str);
  s += " " + tz.toString();
  return s;
}

// -------------------

bool operator == ( const Date& d1, const Date& d2) {
  return d1.getTimeValue() == d2.getTimeValue(); 
}

bool operator < ( const Date& d1, const Date& d2) { 
  return d1.getTimeValue() < d2.getTimeValue(); 
}

bool operator > ( const Date& d1, const Date& d2) { 
  return d1.getTimeValue() > d2.getTimeValue(); 
}


// ---- class TimeZone -----

const TimeZone TimeZone::UTC= TimeZone( 0, "UTC");

TimeZone::TimeZone() {
  tzset();                     // 
  t= - (time_type) timezone;   // use variable 'timezone' from time.h
} 

TimeZone::TimeZone( int offset_minutes, const string& name) {
  t= offset_minutes * 60; 
  this->name= name;
}

string TimeZone::toString() const {
  tm* pzeit;
  time_type t_abs= abs( this->t);
  pzeit= gmtime( &t_abs);

  char str[80];
  char format[]= "%H:%M";
  strftime( str, 80, format, pzeit);
  
  string s= name;
  s += " (";
  s += (t>=0) ? "+" : "-";
  s += str ;
  s += ")";
  return s;
}

