/*
* bs.c
* simple button shell for X11
* Luiz Henrique de Figueiredo (lhf@visgraf.impa.br)
* 05 Nov 92
*/

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

typedef void Callback(Widget w, caddr_t client_data, caddr_t call_data);

void	doargs		(int argc, char* argv[]);
void	makemenu	(void);
void	execute		(char* s);
Widget	addlabel	(char* label);
Widget	addbutton	(char* label, Callback* f, char* p);
void	do_it		(Widget w, caddr_t client_data, caddr_t call_data);
void	do_quit		(Widget w, caddr_t client_data, caddr_t call_data);

static	Widget		toplevel;
static	Widget		form;
static	Widget		wh=NULL;
static	Widget		wv=NULL;
static	FILE*		shell;

#define	getline(s)	fgets(s,sizeof(s),stdin) 

int main(int argc, char* argv[])
{
 shell=popen("/bin/sh","w");
 doargs(argc,argv);
 makemenu();
 XtRealizeWidget(toplevel);
 XtMainLoop();
 return 0;
} 

void doargs(int argc, char* argv[])
{
 char* f;
 toplevel=XtInitialize(argv[0],"bs",NULL,0,&argc,argv);
 switch (argc)
 {
  case 1:
   f=".bsrc";
   break;
  case 2:
   f=argv[1];
   break;
  default:
   fprintf(stderr,"usage: bs [menu-file] [X toolkit options]\n");
   exit(1);
 }
 if (freopen(f,"r",stdin)==NULL)
 {
  fprintf(stderr,"bs: cannot open ");
  perror(f);
  exit(1);
 }
}

void makemenu(void)
{
 char s[BUFSIZ];
 form=XtCreateManagedWidget("form",formWidgetClass,toplevel,NULL,0);
 while (getline(s))
 {
  char* t;
  if (*s=='\n')				/* empty line: new row */
  {
   if (wh!=NULL)
   {
    wv=wh;
    wh=NULL;
   }
   continue;
  }
  t=strchr(s,'\t');
  if (t==NULL)				/* empty command: label */
   wh=addlabel(s);
  else if (t==s)			/* empty label: prolog */
   execute(s);
  else
  {
   *t++=0;
   wh=addbutton(s,do_it,t);
  }
 }
 addbutton("quit",do_quit,NULL);
}

void execute(char* s)
{
 fputs(s,shell);
 fflush(shell);
}

Widget addlabel(char* label)
{
 Widget w=XtVaCreateManagedWidget(label,labelWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	XtNborderWidth,	(XtArgVal) 0,
	NULL);
 return w;
}

Widget addbutton(char* label, Callback* f, char* p)
{
 Widget w=XtVaCreateManagedWidget(label,commandWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	NULL);
 XtAddCallback(w,XtNcallback,f,XtNewString(p));
 return w;
}

void do_it(Widget w, caddr_t client_data, caddr_t call_data)
{
 execute(client_data);
}

void do_quit(Widget w, caddr_t client_data, caddr_t call_data)
{
 pclose(shell);
 exit(0);
}
