\ words.f       - isforth vocabulary listing words
\ ------------------------------------------------------------------------

\ if enough people request that i add color to different word types and
\ can tell me how to colorize user defined word classes i might do it :P

\ might also add substring searches so we can find all words that contain
\ a substring... eventually

\ ------------------------------------------------------------------------
\ display all words in a specific thread

<headers

: ((words))     ( thread --- )
  begin
    dup                         \ keep copy of current nfa address
    count lexmask               \ convert address to a1 n1 (mask n1)
    dup 1+ #out @ +             \ add this to current wcount
    cols >                      \ would display of this word take us
    if                          \ past column 80 ?
      cr                        \ yes - go to start of next line
    then
    type space                  \ and display this word
    4- @ dup 0=                 \ scan 4 bytes back from nfa = lfa
  until                         \ fetch lfa - if not 0 then repeat
  drop ;                        \ else do one more new line and clean up

\ ------------------------------------------------------------------------
\ display all words in specified vocabulary (from each thread)

: (words)       ( vocabulary --- )
  #threads 4* bounds            \ byte size of vocabularies thread array
  do
    i @ ?dup                    \ get address from thread. is it null ?
    if
      ((words))                 \ no thread is used. display words from it
    then
  4 +loop cr ;                  \ advance to next thread

\ ------------------------------------------------------------------------
\ display all words in context

headers>

: words
  cr
  context count 0               \ for each vocabulary in the context array
  do
    cr 
    i 4* over + @               \ get address of vocabulary body
    dup 9 - @                   \ point back at nfa pointer (at cfa -4)
    count lexmask               \ get a1/n1 of nfa
    '[' emit type ']' emit cr   \ display [voc_name]
    cr (words)                  \ display all words in this vocabulary
  loop 
  drop ;                        \ tidy up

\ ------------------------------------------------------------------------

behead

\ ========================================================================
