\ window.f      - isforth console windowing words
\ ------------------------------------------------------------------------

\ ------------------------------------------------------------------------
\ get number of bytes in one window line

: w2    ( w --- w 2*width )
  w.width w@ 2* ;

\ ------------------------------------------------------------------------
\ calculate window size in bytes

: w.size        ( w --- w size )
  w2 >r                     \ size of one line times
  w.height w@ r>            \ number of lines on window
  * ;

\ ------------------------------------------------------------------------
\ allocate buffer for window

: walloc        ( w --- )
  w.size                    \ get number of byres in window
  3 swap                    \ read/write prems
  allocate                  \ allocate buffer... assumes success
  swap w.buffer nip ! ;     \ store buffer address in window structure

\ ------------------------------------------------------------------------
\ relocate cursor in window

: wat           ( w x y --- )
  2>r                       \ save new cursor location
  w.cx r> swap w!           \ set new y coord
  w.cy r> swap w!           \ set new x coord
  drop ;                    \ discard w

\ ------------------------------------------------------------------------

<headers

: (scroll)          ( w --- w size buff )
  dup
  w2 !> ww                  \ get numbrr of bytes per window line
  w.height w@ 1- ww * swap  \ # lines to move * bytes per line
  w.buffer @ nip ;          \ get destination address for move

\ ------------------------------------------------------------------------
\ scroll window contents up 1 line

headers>

: scroll-up         ( w --- )
  (scroll)                  \ get buffer address and length
  ww over + swap            \ get source 
  rot cmove                 \ scroll everything up

\ this is kludgy - erase bottom line of window
\ this also assumes the window is boxed (bad)

  w.height w@ 1- ww * 
  swap w.buffer @ nip +
  dup c@ $2000 + swap

  ww - 2+ ww 2- bounds
  do
    dup i w!
  2 +loop
  drop ;
 
\ ------------------------------------------------------------------------
\ scroll window down

: scroll-dn         ( w --- )
  (scroll)                  \ get buffer address and length
  ww over + 
  rot cmove>
  
  w.buffer @ nip 
  dup c@ $2000 + swap
  ww + 2+ ww 2- bounds
  do
    dup i w!
  2 +loop
  drop ;

\ ------------------------------------------------------------------------
\ stubbs for now - anyone want these?

: scroll-lt ( w --- ) drop ;
: scroll-rt ( w --- ) drop ;

\ ------------------------------------------------------------------------
\ store modified y coordinate back in window structure

<headers

: y!        ( w y --- )
  swap w.cy nip w! ;        \ store y back in structure

\ ------------------------------------------------------------------------
\ store modified x coordinate back in window structure

: x!        ( w x --- )
  swap w.cx nip w! ;        \ decrement and store cursor x

headers>
  
\ ------------------------------------------------------------------------
\ move cursor up in window

: cursor-up     ( w --- )
  w.cy w@ 1- 0<             \ decrement y coordinate
  if
    drop 0                  \ clip to zero
  then
  y! ;

\ ------------------------------------------------------------------------
\ move cursor down in window

: cursor-dn         ( w --- )
  w.cy w@ 1+ >r             \ increment y coordinate
  w.height w@ r> tuck =     \ incremented below bottom of window?
  if
    1-                      \ yes - move back into window
    over scroll-up          \ and scroll window up one line
  then
  y! ;                      \ store y back in structure

\ ------------------------------------------------------------------------
\ move cursor left in window

: cursor-lt         ( w --- )
  w.cx w@ ?dup 0=           \ get cursor x and see if its already zero
  if
    w.width w@              \ yes make x one past right edge
    over cursor-up          \ and cursor up one line
  then
  1- x! ;                   \ decrement x and store back in structure

\ ------------------------------------------------------------------------
\ move cursor right in window

: cursor-rt         ( w --- )
  w.cx w@ 1+ >r             \ get current y coordinate and increment it
  w.width w@ r> tuck =      \ get window width - x beyond right edge?
  if
    drop 0                  \ yes - move x back to left edge and
    over cursor-dn          \ move cursor down
  then
  x! ;                      \ set new cursor x

\ ------------------------------------------------------------------------
\ write char c to window w without advancing cursor

: (wemit)       ( c w --- )
  w.cx w@ 2* swap
  w.buffer @ swap
  w.cy w@ swap
  w.width w@ 2* swap
  w.attrib c@ >r drop
  * + + r>
  over c! 1+ c! ;

\ ------------------------------------------------------------------------
\ write c to window and advance cursor

: wemit         ( c w --- )
  tuck (wemit)              \ write char
  cursor-rt ;               \ advance cursor

\ ------------------------------------------------------------------------
\ write string a1 of length n1 to window w

: wtype         ( w a1 n1 --- )
  bounds                    \ get start and end address of string
  do                        \ for each character of string do
    i c@                    \ get char and output it to window
    over wemit
  loop
  drop ;                    \ discard w

\ ------------------------------------------------------------------------
\ write compiled string to specified window

<headers

: (w")          ( w --- )
  r> count                  \ get address and length of string
  2dup + >r                 \ set return address past end of string
  goto wtype ;

\ ------------------------------------------------------------------------
\ compile string to be written to a window

headers>

: w"        ( --- )
  compile (w")
  $22 parse
  dup c, s, ; immediate

\ ------------------------------------------------------------------------
\ draw top and bottom edges of box

<headers

: tb            ( w --- w )
  over wemit 
  ww                        \ for width of window do
  for
    [ 'q' $80 + ] literal   \ draw upper/lower edge of box character
    over wemit
  nxt ;

\ ------------------------------------------------------------------------
\ draw top line of box in window w

: top           ( w --- w )
  [ 'l' $80 + ] literal     \ write upper left char of box
  tb                        \ draw upper edge of box
  [ 'k' $80 + ] literal     \ draw upper right char of box
  over wemit ;

\ ------------------------------------------------------------------------
\ draw bottom line of box in window w

: bottom        ( w --- w )
  [ 'm' $80 + ] literal     \ draw lower left char of box
  tb                        \ draw lower edge of box
  [ 'j' $80 + ] literal     \ draw lower right char of box 
  over (wemit) ;            \ but dont advance cursor

\ ------------------------------------------------------------------------
\ draw left/right edge character of box

: side          ( w --- w )
  [ 'x' $80 + ] literal     \ write edge character of box
  over wemit ;

\ ------------------------------------------------------------------------
\ draw left and right edges of box in window w

: sides         ( w --- w )
  w.height w@ 2-            \ for height of box do
  for
    side                    \ write left edge character of box
    w.cx ww swap +!         \ add window width to cursor x
    side                    \ write right edge charater of box
  nxt ;

\ ------------------------------------------------------------------------
\ draw box arround edge of window

headers>

: box           ( w --- )
  dup 0 dup wat             \ home cursor on window
  w.width w@ 2- !> ww       \ set width of box edges (minus corners)
  top sides bottom          \ draw box
  drop ;

\ ------------------------------------------------------------------------
\ fill window with data in attrib

<headers

: (clw)         ( w attrib --- )
  dup !> attrib
  over w.attrib nip c!
  w.buffer @ swap           \ get buffer address
  w.size nip                \ get buffer size
  bounds
  do
    attrib i w!
  2 +loop ;

\ ------------------------------------------------------------------------
\ fill background of window with checkerboard character

headers>

: backfill      ( w --- )
  w.attrib c@
  [ 'a' $80 + 8 u<< ] literal
  + (clw) ;

\ ------------------------------------------------------------------------

: clw       ( w attrib --- )
  $2000 +
  (clw) ;

\ ------------------------------------------------------------------------
\ write contents of window into its associated screen

<headers

: (.window)     ( w --- )
  w.height w@ >r            \ number of lines to move
  w.xco w@ !> wx            \ get x coordinate of window on screen
  w.yco w@ !> wy            \ get y coordinate
  w2 !> ww                  \ get # bytes per window line
  w.buffer @ swap           \ get address of window buffer
  w.screen @ nip 
  s.width w@ 2* !> sw       \ get screen width
  s.buffer1 @ nip           \ get address of screen buffer
  wy sw * wx 2* + +         \ get addr of upper left char of win in screen 

  r>
  for
    2dup ww cmove           \ copy 1 line of window into screen buffer
    sw + swap               \ move down one line in screen
    ww + swap               \ advance to next line of window
  nxt 
  2drop ;   

\ ------------------------------------------------------------------------
\ set width, height and default attributes in window structure at a1

headers>

: (window)      ( w h a1 --- )
  -rot 2>r                  \ save width and height
  dup win erase             \ erase structure      
  w.width r> swap w!  
  w.height r> swap w!       \ set window width and height in structure
  w.attrib white swap c!    \ set default atrributes for window
  drop ;

\ ------------------------------------------------------------------------
\ create a named window structure and attach it to screen a1

: window        ( w h --- )
  create                    \ create named window structure
  here                      \ get address of structure
  win allot                 \ allocate the space
  (window) ;                \ fill in structure entries

\ ========================================================================
