\ useful things to have arround
\ ------------------------------------------------------------------------

 forth definitions

\ ------------------------------------------------------------------------
\ like h. but always shows leading zeros

<headers

: .address          ( a1 --- a1 )
  dup 0 <# # # # # # # # # #>
  type ."  | " ;

\ ------------------------------------------------------------------------
\ display 16 bytes of data fron address a1 in hex

: dump-hex          ( a1 --- a1 )
  dup 16 bounds             \ convert a1 n1 into a1 a2
  do
    i c@ 0 <# # # #> type space
  loop '|' emit ;

\ ------------------------------------------------------------------------
\ display 16 bytes of data from address a1 as ascii chars

: dump-asc          ( a1 --- )
  space
  16 bounds                  \ convert a1 n1 into a1 a2
  do
    i c@ ( $7f and )         \ chars 80 - ff mapped to 00 to 7f
    dup $20 <                \ is char emitable ?
    if 
      drop '.'               \ show a . if not
    then
    emit 
  loop ."  |" ;

\ ------------------------------------------------------------------------
\ dump n1 bytes of data from address a1

headers>

: dump          ( a1 n1 --- )
  base @ hex                \ save current base
  -rot
  bounds                    \ convert a1 n1 to a1 a2
  do
    i cr .address           \ show address of next line of data
    dump-hex dump-asc       \ dump the data from this adress
  16 +loop                  \ next address is +16 bytes on
  base ! ;

\ ------------------------------------------------------------------------
\ display top 10 items of parameter stack

: .s 
  depth 10 min 0 ?do i pick . loop ;

\ ------------------------------------------------------------------------

behead

\ ========================================================================
