\ timer.f       - isforth elapsed time measurement and delay words
\ ------------------------------------------------------------------------

create stime  0 , 0 ,       \ start time
create tv     0 , 0 ,       \ long tv_sec long tv_usec
create tz     0 , 0 ,       \ tz_minutswest tz_dsttime 
create sec    0 , 0 ,       \ seconds and ms delay time

\ ------------------------------------------------------------------------
\ syscall <gettimeofday> takes 2 parmeters

 2 78 syscall <gettimeofday> \ tz tv <gettimeofday>

\ ------------------------------------------------------------------------
\ get current number of seconds since epoch in time val struc above

: time@         ( --- )
  tz tv                     \ syscall takes 2 parameters
  <gettimeofday>            \ time val and time zone structure addresses
  drop ;                    \ bleh - it worked!

\ ------------------------------------------------------------------------
\ set start time of operation to be timed to current time

: timer-reset 
  time@ tv stime dmove ;    \ only interested in seconds, minutes and hrs

\ ------------------------------------------------------------------------
\ factored out just to confuse you :)

: mswap ( n1 --- n2 n3 ) /mod swap 0 ;
: 60m 60 mswap # # ;        \ extract min or sec
: 10m 10 mswap ;            \ as above but for 10ths, 100ths and 1000ths

\ ------------------------------------------------------------------------

: (t) 
  60m ':' hold 
  2drop ;

\ ------------------------------------------------------------------------
\ display ammount of time elapsed since timer-reset

: .elapsed
  base @ decimal

  time@ 
  tv @ stime @ -
  [ tv    4+ ] literal @
  [ stime 4+ ] literal @ - 
 
  <#
  10m # 2drop 
  10m # 2drop  
    0 # 2drop '.' hold  

  (t) (t)  
  60m #> type drop 
  base ! ;

\ ------------------------------------------------------------------------
\ allocate nanosleep syscall

 2 162 syscall <nanosleep> 

\ ------------------------------------------------------------------------

<headers

: (nano)
  begin
    sec sec <nanosleep> 0= 
  until ;

headers>

\ ------------------------------------------------------------------------
\ delay n1 seconds 

: seconds           ( n1 --- )
  sec !
  [ sec 4+ ] literal off
  goto (nano) ;

\ ------------------------------------------------------------------------
\ delay n1 microseconds

: ms                ( n1 --- )
  1000 /mod sec !
  1000000 * [ sec 4+ ] literal !
  goto (nano) ;

\ ------------------------------------------------------------------------

 behead

\ ========================================================================
