\ term.f        - isforth terminfo handling words
\ -------------------------------------------------------------------------

 vocabulary terminal terminal definitions

\ ------------------------------------------------------------------------

\ create ti-file 
\   ," /usr/share/terminfo/x/" 
\   here 10 allot 10 erase    \ space filled in with term name
 
 create env_term
   ," TERM="
 
\ 0 var terminfo              \ address of terminfo data 

\ ------------------------------------------------------------------------
\ allocate lseek syscall

\ 3 19 syscall <lseek>

\ ------------------------------------------------------------------------
\ create full path it terminfo file

\ : >ti           ( a1 n1 ---  )
\   over c@                   \ get first character of terminfo file name
\   [ ti-file $15 + ] 
\   literal c!                \ overwrite x
\   dup                       \ get copy of lenght of file name
\   ti-file c@                \ get length of above path
\   +                         \ add the lengths
\   ti-file c!                \ length of path and file name
\   [ ti-file $17 + ] literal
\   swap cmove                \ append name to path
\   0 ti-file count + c! ;    \ make name ascii z for syscall bleh

\ ------------------------------------------------------------------------

\ : read-ti
\   0 ti-file 1+ <open>       \ open terminfo file
\   ?dup
\   if
\     2 0 pluck <lseek>       \ ( fd size --- )
\     >r
\     0 0 pluck <lseek>       \ seek back to start of file
\     drop r>
\     dup negate +!> thead    \ allocate buffer for terminfo data
\     thead rot dup>r         \ put parameters in correct order
\     <read> drop             \ read file (assume we did ok :p)
\     r> <close> drop         \ close terminfo file
\     thead !> terminfo
\   then ;

\ ------------------------------------------------------------------------

\ : get-ti
\   env_term getenv           \ did anyone bother to set $term env ?
\   if
\     >ti read-ti             \ create full path to terminfo file and read 
\   then ;

\ ------------------------------------------------------------------------
\ word to compile a terminal escape sequence

<headers

: sequence
  create                    \ create sequence word
  bl word                   \ parse sequence from input
  hhere dup c@ 1+           \ copy parsed sequence into body of new word
  here over
  allot
  swap cmove
  does>                      \ execution of new word types its own body
    count swap 1 
    <write> drop ;

\ ------------------------------------------------------------------------
\ escape sequences - by hand - till i get terminfo parsing sorted

sequence (sc)  7           \ save cursor
sequence (rc)  8           \ restore cursor  
sequence (cuu) [001A       \ cursor up
sequence (cud) [001B       \ cursor down
sequence (cuf) [001C       \ cursor forward
sequence (cub) [001D       \ cursor backwards
sequence (hpa) [001G       \ cursor to column n
sequence (cup) [001;001;H  \ cursor to row;column
sequence (ed)  [2J         \ erase display
sequence (vpa) [001d       \ cursor to line n
sequence (sgr) [000m       \ set attribute
sequence (csr) [001;001r   \ set scroll region

\ sequence (ind) a           \ scroll forward
\ sequence (sr)  M           \ scroll reverse 
\ sequence (ich) [001@       \ insert character
\ sequence (el)  [2K         \ erase line
\ sequence (il)  [001L       \ insert line
\ sequence (dch) [001M       \ delete chars
\ sequence (ech) [001X       \ erase chars
\ sequence (cpr) [6n         \ report cursor pos

headers>

sequence repm [?9h         \ report mouse buttons
sequence nrep [?9l         \ dont report mouse buttons

sequence curoff [?25l      \ hide cursor
sequence curon  [?25h

\ ------------------------------------------------------------------------

: sc    ( --- ) (sc) ;      \ remember current cursor location
: rc    ( --- ) (rc) ;      \ put cursor back where it was remembered
: cuu   ( --- ) (cuu) ;     \ cursor up (once for now)
: cud   ( --- ) (cud) ;     \ cursor down (once for now)
: cuf   ( --- ) (cuf) ;     \ cursor forwards (once for now)
: cub   ( --- ) (cub) ;     \ cursor backwards (once for now)

\ : ind   ( --- ) (ind) ;     \ scroll display forward
\ : sr    ( --- ) (sr) ;      \ scroll display reverse
\ : ich   ( --- ) (ich) ;     \ insert char (only 1 for now)
\ : il    ( --- ) (il) ;      \ insert line
\ : dch   ( --- ) (dch) ;     \ delete characters
\ : ech   ( --- ) (ech) ;     \ erase characters

\ ------------------------------------------------------------------------
\ patch terminal sequence with parameter n1

<headers

: seq1      ( n1 --- )
  base @ decimal swap
  r@ @                      \ get sequence to patch
  11 + hld !                \ point hld at sequence parameter
  0 # # # 2drop             \ patch sequence parameter
  base ! ;

\ ------------------------------------------------------------------------
\ patch terminal sequence with parameters n1 and n2

: seq2      ( n1 n2 --- )
  base @ decimal -rot
  r@ @                      \ get sequence to be patched
  15 + hld !                \ point hld at second parameter in sequence
  0 # # # 2drop             \ patch second parameter
  decr> hld                 \ skip ';' character
  0 # # # 2drop             \ patch first parameter
  base ! ;

headers>

\ ------------------------------------------------------------------------
\ put cursor in column n1

: hpa   ( n1 --- )
  dup #out !
  1+ seq1 (hpa) ;

\ ------------------------------------------------------------------------
\ put cursor on line n1

: vpa   ( n1 --- )
  dup #line ! 
  1+ seq1 (vpa) ;

\ ------------------------------------------------------------------------
\ set cursor locarion to row r, column c

: cup   ( c r --- ) 
  2dup #out ! #line ! 
  1 dup d+
  seq2 (cup) ;

' cup alias at

\ ------------------------------------------------------------------------

\ : ed ( --- ) (ed) ;         \ erase display (all of it for now)
\ : el ( --- ) (el) ;         \ erase line (all of it for now)

' (ed) alias ed
' (ed) alias cls

\ ------------------------------------------------------------------------
\ set scroll region to 

: csr   ( blah blah --- ) 
  seq2 (csr) ;

\ ------------------------------------------------------------------------
\ set attrributes

: sgr  ( n1 --- ) seq1 (sgr) ;

\ ------------------------------------------------------------------------
\ escape sequence returned by console says where cursor is

\ <headers
\
\ : (?cursor)       ( c1 --- n1 )
\  >r
\  key '0' -
\  begin
\    key dup r@ <>
\  while
\    '0' - 
\    swap 10 * + 
\  repeat
\  r>drop drop  ;

\ headers>

\ ------------------------------------------------------------------------
\ get current cursor location

\ : ?cursor       ( --- y x )
\   (cpr)                     \ ask where the cursor is 
\   begin                     \ wait for start of reply
\     key $1b =               \ might be floading - stdin might not be
\   until                     \ where key gets its data!
\   key drop                  \ discard '[' char
\   ';' (?cursor)             \ read chars till ';' 
\   'R' (?cursor) ;           \ read chars till 'R'

\ ------------------------------------------------------------------------

: ?term
  pad $5413 0 <ioctl>       \ get window size using ioctl
  pad w@ !> rows            \ set window size variables
  pad 2+ w@ !> cols
  rows 0 at ;
\  pad 6 + w@ ....  pixle width/height?
\  pad 8 + w@ .... ;

\ ------------------------------------------------------------------------ 
\ forth will need to know what the terminals display size is!

<headers

: z
  defers default
  ?term ;

\ ------------------------------------------------------------------------

behead forth definitions

\ ========================================================================
