\ status.f      - isforth displays status in top line
\ ------------------------------------------------------------------------

 forth definitions

\ ------------------------------------------------------------------------

<headers

 false var status           \ status is off/on ?

headers>

\ ------------------------------------------------------------------------
\ turn status line on - set scroll region below status line

: staton        ( --- )
  on> status                \ we are displaying status info now
  sc 2 rows csr             \ set scroll region
  rc ;

\ ------------------------------------------------------------------------
\ turn status line off - scroll through status line is ok now

: statoff       ( --- )
  off> status               \ status not being displayed
  sc 1 rows csr             \ set scroll region
  rc ;

\ ------------------------------------------------------------------------
\ display free list space, display free head space

: .lfree tlist here  - 7 .r ;
: .hfree thead hhere - 7 .r ;

\ ------------------------------------------------------------------------
\ display status line in row 1

\ ugh - this is ugly code

<headers

: (.status)
  status 0= ?exit           \ is status enabled ?
  floads @ ?exit            \ no status update during fload

  #out @
  sc fg bg                  \ ok - save cursor location bg and fg colours
  pref @ base @             \ bold underline and current base saved
  decimal
  curoff

  0 0 at >attrib1
  ."  List        Head        Depth      Base   "
  >bold yellow >fg 
  5 hpa .lfree
  17 hpa .hfree
  31 hpa depth 5 - 4 .r 
  41 hpa dup 2 .r
  space
  green >fg .date
  cols #out @ - 
  dup 7 > 
  if
    7 - spaces
    cyan >fg ." MIMIV "
  else
    1- spaces 
  then

  curon
  base ! >pref >bg >fg 
  rc #out ! ;

' (.status) is .status

\ ------------------------------------------------------------------------

: init-stat
  defers default
  staton ;

\ ------------------------------------------------------------------------
\ patch staton into forths defered init chain

\ we need to reset the scroll region on exit

: deinit-stat               \ lets not exit forth with a modified scroll
  defers atexit             \ region :)
  statoff ;

\ ------------------------------------------------------------------------

behead

\ ========================================================================
