\ screen.f      - isforth text user interface screen handling words
\ ------------------------------------------------------------------------

\ ------------------------------------------------------------------------
\ copy all windows attached to screen into screen buffer 1

<headers

: .windows      ( s --- )
  s.window @ nip            \ get address of first window in chain
  begin
    ?dup                    \ reached end of chain?
  while
    dup .window             \ no draw window into screen
    w.next @ nip            \ link back to previous window in chain
  repeat ;

\ ------------------------------------------------------------------------
\ reposition cursor if its not there already

: s-at          ( x y --- )
  dup #line @ =             \ see if currect cursor y = requested y ?
  pluck #out @ = and        \ see if current cursor x = requested x
  ?:
    2drop                   \ both coordinates matched
    at ;                    \ one or both didnt, reposition cursor

\ ------------------------------------------------------------------------
\ modify current character attributes

: ?>attrib      ( n --- )
  attrib over =             \ is this attrib different?
  if
    drop exit               \ no, discard and return
  then
  dup !> attrib             \ yes - remember it
  >attrib ;                 \ set current terminal colours

\ ------------------------------------------------------------------------
\ set console to using normal font

: font0
  ." (B" ;                 \ select normal charset

\ ------------------------------------------------------------------------
\ switch to ibm box charset font

: font1
  ." (0" ;                 \ select ibm box charset font

\ ------------------------------------------------------------------------
\ select new charset

: >font         ( f  --- )
  dup !> font               \ remember current font 
  ?:                        \ switch to selected charset
    font1                   \ box charset
    font0 ;                 \ normal charset

\ ------------------------------------------------------------------------
\ output one character of screen data to console

: s-emit        ( c x y --- )
  s-at                      \ position cursor in terminal
  dup $ff and ?>attrib      \ extract attribute byte from char
  8 u>> dup                 \ extract character itself
  $80 and                   \ extract font bit 
  dup font =                \ already using this charset?
  ?:
    drop                    \ yes, discard font bit
    >font
  $7f and emit ;            \ write character to console

\ ------------------------------------------------------------------------
\ fetch next character from window and write it to console

: .char         ( x y offset --- )
  dup 
  sb1 + >r sb2 +            \ calculate char addr in both screen buffers
  dup w@ r@ w@ =            \ did this char change from last time?
  if
    r>drop 3drop            \ no discard all junk
    exit
  else
    -rot                    \ yes save buffer 2 address
    r> w@ dup>r             \ read char from buffer 1
    -rot s-emit             \ write it out to console
    r> swap w!              \ store chare in buffer 2
  then ;

\ ------------------------------------------------------------------------
\ write changed contents of window buffer to display

: (.screen)     ( --- )
  0                         \ offset to current line
  0 0                       \ current x and y coordinates
  sh                        \ for height of screen do
  for
    sw                      \ for width of screen do
    for
      3dup rot              \ copy all parameters, rotate out line offset
      over 2* +             \ add in x coordinate
      .char                 \ display char at this offset at this x/y
      1+                    \ increment xco
    nxt
    drop 1+                 \ discard x, increment y
    swap sw 2* +            \ anvance offset to start of next line 
    swap
    0                       \ x in now 0
  nxt
  3drop 
  off> font font0 ;

\ ------------------------------------------------------------------------
\ write changed contents of entire screen out to console

headers>

: .screen       ( s --- )
  0 0 at
  dup .windows              \ draw all windows into screen buffer

  s.buffer1 @ !> sb1        \ get address of this screens first and second
  s.buffer2 @ !> sb2        \ buffers
  s.width w@ !> sw          \ get this screens width and height
  s.height w@ !> sh
  drop                      \ discard s
  (.screen) ;               \ write screen to console

\ ------------------------------------------------------------------------
\ scan to end of window chain

<headers

: (attach)      ( w --- w w.next )
  begin
    w.next dup @            \ if this windows w.next is not null
  while
    nip @                   \ fetch w.next discard previous w
  repeat ;

\ ------------------------------------------------------------------------
\ attach window w to screen s

headers>

: attach        ( s w --- )
  2dup w.screen nip !
    w.next off              \ erase link field of new w
  swap
  s.window dup @            \ any windows already attached to this screen?
  if
    @ nip                   \ get address of first window in chain
    (attach)                \ get address of last window in chain
  then
  nip ! ;                   \ store w in link address

\ ------------------------------------------------------------------------
\ search linked window list for window to detach

<headers

: (detach)
  sb1 s.window @ nip
  begin
    w.next @ 
    dup wb <>
  while
    nip
  repeat
  drop
  wb w.next @ nip 
  swap w.next nip ! ;

headers>

\ ------------------------------------------------------------------------
\ detach a window from its associated screen

: detach        ( w --- )
  dup !> wb                 \ remember window structure address
  w.screen @ nip            \ get its associated screen
  dup !> sb1                \ remember screen structure address
  s.window @ nip wb =       \ is our window the first one attached?
  if
    wb w.next @ nip         \ yes, get address of next window if any
    sb1 s.window nip !      \ store this as first one in screen
  else
    (detach)                \ no, search window list for one to delete
  then ;

\ ------------------------------------------------------------------------
\ allocate buffers for screen s

: salloc        ( s --- )
  s.width w@ 2* >r          \ get width *2
  s.height w@ r> *          \ multiply by height = byte size of buffers
  3 swap 2dup               \ read/write permissions
  allocate -rot             \ allocate buffer 2
  allocate                  \ allocate buffer 1
  rot tuck
  s.buffer1 nip !           \ set buffer 1 address in structure
  s.buffer2 nip ! ;         \ set buffer 2 address in structure

\ ------------------------------------------------------------------------
\ set width w and height h of screen s

: (screen)      ( w h s --- )
  -rot 2>r                  \ save width and height
  dup scr erase             \ erase screen structure
  s.width r> swap w!        \ store screen width in structure
  s.height r> swap w!       \ store screen height in structure
  drop ;                    \ discard screen address
  
\ ------------------------------------------------------------------------
\ create a named screen structure and allocate buffers

: screen        ( w h --- )
  create                    \ create named screen structure
  here scr allot            \ get address of structure 
  (screen) ;                \ fill in screen structure

\ ========================================================================
