\ memory.f      - isforth memory allocation and deallocation words
\ ------------------------------------------------------------------------

\ ------------------------------------------------------------------------

<headers

 0 var last-map               \ last memory map created

\ ------------------------------------------------------------------------
\ atructure to store information about block of allocated memory

struct: mmap
  1 dfield m.previous
  1 dfield m.address
  1 dfield m.size
;struct 

\ ------------------------------------------------------------------------
\ allocate a new mmap structure

: (>mmap)       ( --- m )
  mmap <head                \ allocate a map structure
  m.previous last-map       \ chain to previous structure
  swap !
  dup !> last-map ;         \ remember most recent mmap structure

\ ------------------------------------------------------------------------
\ search linked list of mmap structures for an unused one

: (?>mmap)      ( m1 --- m2 )
  begin
    m.address @ 0= ?exit    \ is this an unused entry ? 
    m.previous @ nip        \ scan back to previous structure
    ?dup 0=                 \ reached end of chain ?
  until
  (>mmap) ;                 \ no free structures, create a new one
 
\ ------------------------------------------------------------------------
\ find free mmap structure to use or create a new one

: >map      ( --- m )
  last-map ?dup             \ any mmap structures defined?
  ?:
    (?>mmap)                \ yes, search list
    (>mmap) ;               \ no, create one
 
\ ------------------------------------------------------------------------
\ allocate size bytes of memory with specified permissions

headers>

: allocate      ( perms size --- a1 | false )
  pad dup>r 24 erase        \ clear mmap parameters structure
  $fff + -$1000 and         \ make size a multiple of 4k (page size)
  r@ 4+ !                   \ set size of mapping
  r@ 8 + !                  \ set permissions
  $21 r@ 12 + !             \ flags (anonymous, shared)
  r> <mmap>                 \ allocate memory

  dup -1 =                  \ map failed?
  if 
    drop 0 exit
  then

  >r                        \ save buffer address
  >map                      \ allocate mmap structure

  m.address r@ swap !
  m.size pad 4+ @ swap !    \ set size of memory block
  r> nip ;

\ ------------------------------------------------------------------------
\ deallocate memory for mmap descriptor m

<headers

: (free)        ( m --- )
  m.size @ swap             \ get size of mapping
  m.address @ swap -rot     \ get buffer address of mapping
  <munmap> drop             \ unmap buffer
  m.address off drop ;      \ mark descriptor as unused

\ ------------------------------------------------------------------------

headers>

: free      ( a1 --- )
  >r                        \ save address to deallocate
  last-map                  \ get most recent mmap descriptor address
  begin
    m.address @ r@ =        \ get buffer address of this structure
    if                      \ same as one to free ?
      r>drop goto (free) 
    then
    m.previous @ nip        \ scan back to previous structure
    ?dup 0=                 \ end of chain?
  until
  r>drop ;                  \ ignore attempt to free unknown block of memory

\ ------------------------------------------------------------------------

behead

\ ========================================================================
