\ header.f      - isforth headerless word create
\ ------------------------------------------------------------------------

 compiler definitions

\ ------------------------------------------------------------------------

 vocabulary h-voc h-voc     \ create and put in context

\ ------------------------------------------------------------------------
\ make current headerless state headerless!

hp @                        \ remember true header memory address
current @                   \ remember current vocabulary
definitions                 \ put h-voc in current
over 8192 + hp !            \ headerless headers temp compile address

\ you have the ability to create 8k's worth of headerd words when creating
\ headerless words. you should behead before that limit is reached though

\ -- we are now compiling headerless

   var h-current            \ real current vocabulary (value is on stack)
   var h-hp                 \ hp true address           "      "      "
 2 var h-state              \ current headerless state

\ 0 = no headerless words defined
\ 1 = headerless words created, headers are on
\ 2 = headerless words created, headers are off

\ -----------------------------------------------------------------------
\ zero out all threads of headerless vocabulary

: z-head
  [ ' h-voc >body ] literal
  256 erase ;

\ ------------------------------------------------------------------------
\ state is not headerless but has been before. go headerless again

: h1        ( --- )
  current @ !> h-current    \ remember true current
  h-hp                      \ address where headerless headers end
  hp @ !> h-hp              \ remember where true hp left off
  hp !                      \ append headers to headerless headers buffer
  2 !> h-state              \ all words are created headerless
  h-voc definitions ;       \ adds h-voc to context and current

\ ------------------------------------------------------------------------
\ going headerless for first time

: h0
  hp @ 8192 + !> h-hp       \ point hp 8k beyond where it realy is
  z-head h1 ;               \ erase h-voc threads and go headerless
  
\ ------------------------------------------------------------------------
\ turn headers off

: <headers
  h-state
  exec: h0 h1 noop ;
 
\ ------------------------------------------------------------------------
\ turn headers back on

: headers>      ( --- )
  h-state 1 = ?exit         \ were already back in headerfull mode
  h-state 0= abort" Not in headerless mode"

  decr> h-state             \ headers are on again now
  hp @                      \ where headerless headers left off..
  h-hp hp !                 \ headers compiling into normal head space
  !> h-hp
  h-current current ! ;     \ h-voc is still in context though

\ ------------------------------------------------------------------------
\ zero pointers to nfa at cfa -4 for all words in a thread

: (nonames)     ( thread --- )
  ?dup 0= ?exit             \ empty thread?
  begin                     \ for each header in thread do
    dup name> @             \ scan to cfa pointer and get cfa
    4- off                  \ erase nfa pointer at cfa -4
    4- @                    \ point to nfa of previous word in thread
    ?dup 0=                 \ reached end of chain ?
  until ;
  
\ ------------------------------------------------------------------------
\ zero pointers to nfa at cfa -4 for all words in the h-voc vocabulary

: nonames
  [ ' h-voc >body ] literal \ point at body of h-voc
  #threads 4* bounds        \ for each thread of hvoc do
  do
    i @ (nonames)           \ remove links to nfa from cfa-4 
  4 +loop ;

\ ------------------------------------------------------------------------
\ these definitions will be made headerless - prevent this

headers>                    \ turn headers back on

' <headers alias <headers   \ both of these words can be thought of as
' headers> alias headers>   \ pointing towards where headered words are

\ ------------------------------------------------------------------------
\ erase all headers - gone forever

: behead
  headers>                  \ turn headers on again
  h-voc previous            \ remove from context
  off> h-state              \ no longer headerless
  nonames                   \ make all beheaded words noname
  z-head ;                  \ erase all threads in h-voc

\ ------------------------------------------------------------------------

 forth definitions behead

\ ========================================================================
