\ forget.f      - isforth word forgetting words
\ ------------------------------------------------------------------------

root definitions

\ ------------------------------------------------------------------------

\ warning:  forgetting the current vocabulary makes forth current and
\           will place forth in context even if it wasnt there previously

\ ------------------------------------------------------------------------

  0 var fence               \ cannot forget below this address

\ ------------------------------------------------------------------------

<headers

 0 var thd                  \ top of head space on entry 

\ ------------------------------------------------------------------------
\ set top of head memory on entry into isforth

: ?top
  defers default
  hhere !> fence
  thead !> thd ;

\ any words defered into default after this one that allocate memory
\ with <head are going to have the rug pulled out from under them if 
\ we do an empty

\ ------------------------------------------------------------------------
\ return address of first word below a1 in thread

: (trim)    ( a1 top-of-thread --- a1 bottomish-of-thread )
  begin
    2dup > not              \ if word is higher up in mem than a1
  while
    4- @                    \ read link to previous word
  repeat ;

\ ------------------------------------------------------------------------
\ trim thread to below a1

: trim          ( a1 thread --- a1 thread )
  dup>r                     \ remember thread address
  @                         \ fetch first item in chain from thread
  dup                       \ any words chained in this thread ?
  if
    (trim)                  \ get address of first word in thread below a1
  then
  r@ !                      \ store new end of thread address
  r> ;
 
\ ------------------------------------------------------------------------
\ delete all words from voc that are above word a1

\ a2 is the address within a vocabulary that links to the previous voc

: (forget)      ( a1 voc --- a1 a2 )
  #threads 0
  do
    trim                    \ trim this thread of anything above a1
    4+                      \ advance to next thread
  loop ;

\ ------------------------------------------------------------------------
\ remove forgotten vocabulary from context and current if its there

: (forgetv)     ( a1 --- a1 )
  dup current @ =           \ are we forgetting the current vocabulary ?
  if
    forth definitions       \ yes - make forth current
  then

  context count 4* bounds   \ scan through context stack
  do
    i @                     \ get vocabulary address from contexzt
    over =                  \ are we forgetting this vocabulary ?
    if
    ( dup )                 \ retain a1
      dup dovoc ( drop )    \ trickerty, see below - bring voc a1 to top
      previous              \ discard top item of context stack (now a1)
    then
  loop ;

\ normally when you invoke a vocabulary its cfa calls dovoc.  this leaves
\ the body address of the vocabulary on the stack for dovoc's pleasure.  
\ we cannot just do "address dovoc" because address would be in ebx 
\ because top of stack is cached.  so, to force address to be on the 
\ stack itself when we call dovoc i push a second item onto the stack 
\ which we later drop

\ ------------------------------------------------------------------------
\ unlink vocabularies above forgotten word

: ?forgetv       ( a1 --- a1 )
  voclink @                 \ have any vocabularies been forgotten
  begin
    2dup 9 - @ 
    > not                   \ is this a forgotten vocabulary ?
  while
    (forgetv)               \ remove this voc from context if its there
    [ #threads 4* ] literal
    + @
  repeat
  voclink ! ;

\ ------------------------------------------------------------------------
\ forget word whose nfa is on the stack

: frgt      ( nfa --- )
  dup fence <
  abort" Below Fence"

  voclink @                 \ get address of most recent vocabulary
  begin                     \    ( a1 voc --- )
    (forget)                \ forget everything above a1 in voc
    \ now pointing at link to previous voc
    @ ?dup 0=               \ null link?
  until

  ?forgetv                  \ handle vocabularies being forgotten

  dup name> @ 4- dp !       \ set dp to cfa -4 of word to forget
  4- hp ! ;                 \ set hp to lfa of word to forget

\ ------------------------------------------------------------------------

headers>

: forget        ( --- )
  ' 4- @ frgt ;             \ point at nfa of word to forget and forget it
 
\ ------------------------------------------------------------------------

<headers

: (mark)       ( a1 --- )
  dup @ !> thead
  9 - @ frgt ; 

headers>

\ ------------------------------------------------------------------------
\ create a self forgetting word

: mark
  create                    \ create header
  thead ,                   \ so we can forget <head allocated buffers too
  does> 
    (mark) ;

\ ------------------------------------------------------------------------

: empty
  thd !> thead
  fence
  dup hhere <>
  if
    4+ frgt
  else
    drop
  then ;

\ ------------------------------------------------------------------------

behead forth definitions

\ ========================================================================
