\ color.f       - isforth console colour handling stuff
\ ------------------------------------------------------------------------

 terminal definitions

\ ------------------------------------------------------------------------
\ colours

0 const black
1 const red
2 const green
3 const yellow
4 const blue
5 const magenta             \ i would call this pink myself
6 const cyan
7 const white

\ ------------------------------------------------------------------------
\ isforth default palette settings ( thanx rasterman :)

\ not being used, i just change magenta to be less pink :P

\ create palette
\ ,' 00000001aa000020088003aa552240000aa'
\ ,' 5550055600aaaa7aaaaaa84444449ff4444'
\ ,' a44ff44bffff44c4444ffdff44ffe44ffff'
\ ,' fffffff'

\ ------------------------------------------------------------------------

<headers

: xterm-pal
  ." ]4;0;black]4;1;red4]4;2;green4]4;3;yellow4"
  ." ]4;4;blue4]4;5;magenta4]4;6;cyan4]4;7;white4" ;

headers>

\ ------------------------------------------------------------------------
\ determin which terminal we are running in

 create terms ,' linuxEtermxterm'

: ?terminal     ( --- n1 t | f )
  env_term getenv           \ what terminal is being used
  dup not ?exit             \ $term not set in environment (duh!)
  drop                      \ ( a1 n1 --- ) term name address and length
  3 0                       \ for each supported terminals
  do
    2dup                    \ dont lose term name address
    terms i 5 * +           \ get address of next supported term name
    swap comp               \ is the whats being used ?
    if
      2drop                 \ yes discard a1 n1
      i true                \ i = terminal number
      undo exit             \ break out of loop and exit
    then
  loop
  2drop 0 ;                 \ not supported - add it then tell me :)

\ ------------------------------------------------------------------------
\ palette settings for eterm and linux terminal

\ make magenta less of a girlie pink colour

<headers : eterm-pal  ." ]P5550055" ; headers>

\ ed
\ 8 0 
\ do
\    ." ]P"
\   7 palette i 7 * + 1 <write> 
\ loop ;

\ ------------------------------------------------------------------------

: >pal  ( --- ) 
  ?terminal not ?exit
  exec: 
    eterm-pal 
    eterm-pal 
    xterm-pal ;

\ -----------------------------------------------------------------------
\ set default attributes

\ white var fg
\ black var bg
 white var bg
 black var fg

 variable pref pref off     \ no bold or underline etc

\ ------------------------------------------------------------------------
\ set forground colour

: >fg   
  dup !> fg 30 + sgr ;

\ ------------------------------------------------------------------------
\ set background colour
                
: >bg   
  dup !> bg 40 + sgr ;   

\ ------------------------------------------------------------------------
\ set default fg/bg etc

: >norm 
\  off> bg white !> fg       \ remember current attribs
  off> bg black !> fg       \ remember current attribs
  off> pref 
  0 sgr ;      

\ ------------------------------------------------------------------------

: setpref ( n --- ) pref cset ;
: clrpref ( n --- ) pref cclr ;

\ ------------------------------------------------------------------------
\ not needed, just set the colours you want

\ : >rev  1 setpref 17 sgr ;     \ turn on reverse 
\ : <rev  1 clrpref 27 sgr ;     \ turn off reverse

\ ------------------------------------------------------------------------

: >bold 2 setpref 1 sgr ;      \ turn bold on
: <bold 2 clrpref 22 sgr ;     \ turn bold off
: >ul   4 setpref 4 sgr ;      \ turn underline on
: <ul   4 clrpref 24 sgr ;     \ turn underline off

: >attrib
  dup $f and >fg
  4 u>> >bg ;

: >attrib1 
  [ blue 4 u<< white + ] literal
  >attrib ; 

\ ------------------------------------------------------------------------
\ set attribute preferences accoding to n1

: >pref         ( n1 --- )
\  dup 1 and ?: >rev <rev
  dup 2 and ?: >bold <bold
      4 and ?: >ul <ul ;

\ ------------------------------------------------------------------------
\ set isforth default colours etc

\ for some reason xterm accepts the >pal but doesnt act on it - it works
\ if you run it from the forth terminal however - doh!

: defcol
  defers default
  off> pref 
  >pal ;

\ ------------------------------------------------------------------------

 behead forth definitions

\ ========================================================================
