\ case.f        - isforth case compilation and execution
\ ------------------------------------------------------------------------

 compiler definitions

\ ------------------------------------------------------------------------

\ this version of case is dedicated to MrReach who challenged me to write
\ a better version - it took me 12 hours of bravado on irc and 2 hours
\ of coding in bed later that night to write :)

\ he subsequently requested that these definitions be renamed because of
\ the differences between these words and the standard words.

\ i think these word names are more forthy :)

\ ------------------------------------------------------------------------

<headers

 0 var [cse]                \ temp case vector compile buffer pointer
 0 var [dflt]               \ default case vector

\ ------------------------------------------------------------------------
\ get address of temporary case compile buffer

: >case tlist 100 - ;       \ top of list space - 100 bytes

\ this is enough space for exactly 25 cases in a case statement. if your
\ code needs more then i suggest a job at jiffy lube instead

headers>

\ ------------------------------------------------------------------------
\ get default for case: statement

\ dflt can go anywhere inside a case: statement

: dflt ( --- ) 
  ' !> [dflt] ;             \ compiled in later by ;case

\ ------------------------------------------------------------------------
\ initiate a case statement 

: case:        ( --- 0 )
  compile docase            \ compile run time handler for case statement
  >case !> [cse]            \ point to temp case compile buffer
  off> [dflt]               \ assume no default vector
  >mark                     \ case exit point compiled to here
  >mark                     \ default vector filled in by ;case (maybe)
  >mark                     \ number of cases compiled to here
  0                         \ number of cases is 0 so far 
  [compile] [ ; immediate

\ ------------------------------------------------------------------------
\ should i rename this one back to 'of' ?

: opt          ( #cases n1 --- )
  ,                         \ compile n1 as case option
  1+                        \ increment # cases
  ' [cse] !                 \ store option in temp buffer
  4 +!> [cse] ;             \ advance buffer address

\ the above is slightly deceptive, the store does not store into [cse]
\ but into where [cse] points to - the +!> advances the pointer by 1
\ cell

\ ------------------------------------------------------------------------
\ i resisted the urge to call this word esac :P (phew!!!)

: ;case         ( a1 a2 a3 n1 --- )
  rot [dflt] swap !
  tuck swap !               \ save # cases, compile same into case body
  >case                     \ get address of temp case compile buffer
  here rot                  \ here is where we place the case vectors
  4* dup allot              \ calculate byte size of case vectors
  cmove                     \ move vectors into allocated buffer
  >resolve                  \ store case end point in case body
  [compile] ] ;

\ ------------------------------------------------------------------------

 forth definitions behead

\ ========================================================================
