\ args.f        - isforth command line tail and #! handling words
\ ------------------------------------------------------------------------

<headers

 0 var >tail                \ current position in tail
 0 var #tail                \ # chars in tail

 0 var shebang              \ true if we were launched by a shebang

create pwd ," PWD"          \ seemingly always the first env var

\ ------------------------------------------------------------------------
\ demangle os mangled command line args

\ this still needs work, we cant easilly pass parameters to a forth
\ script file as the following code gives them to forth to interpret
\ this prevents us from doing things like ./script.f *.foo as forth
\ will tell us *.foo ?

\ any parameters after the script file name should realy belong to the
\ script itself not forth (mental note: fix this)

headers>                    \ this might be useful for apps 

: fixargs           ( --- )
  argp argc 1- 0            \ for each arg do..
  ?do
    scanz                   \ scan from address to ascii null
    bl over c!              \ overwrite z with blank
  loop

  scanz                     \ scan to end of last known arg

  dup 1+                    \ is there another arg ?
  pwd count comp not
  if                        \ only happens when launched from a #!
    on> shebang             \ automatic bye when script ends
    bl over c!
    scanz                   \ scan to end of shebanged filename
  then                     

  argp - !> #tail  ;        \ remember total length of args

<headers
 
\ ------------------------------------------------------------------------
\ see if there is anything left in the command line tail to interpret

\ n1 = number of chars left to interpret

: ?endtail          ( --- n1 | no-return )
  #tail >tail 2dup <        \ number of chars in tail not yet interpreted
  if                        \ all done ?
    shebang                 \ if we have just completed execution of a 
    if                      \ shebanged script then we go bye bye here
      errno @ <exit>        \ quietly but returning errno
    then

    2drop                   \ else we set up for normal terminal input
    ['] query is refill     \ reset tib refill method
    >in off #tib off        \ purge tib
    r>drop                  \ discard return address
    exit                    \ exit to callers caller
  then 
  - ;

\ ------------------------------------------------------------------------
\ parse 1 arg in tail 

\ n1 is number of chars as yet unparsed in tail
\ a1 = address of start of parsed arg
\ a2 = address of end of parsed arg

: parse-arg         ( n1 --- a2 a1 )
  argp >tail +              \ get current position within tail
  dup>r                     \ remember it
  begin                     \ ( n1 a1 --- )
    dup c@                  \ get char from tail
    bl <>                   \ while it isnt a space
    pluck 0<> and           \ and there are still chars left 
  while
    swap 1-                 \ decrement #chars
    swap 1+                 \ advance address
  repeat
  nip r> ;

\ ------------------------------------------------------------------------
\ refill tib with one word from command line tail

: arg>tib          ( --- )
  ?endtail                  \ interpreted to end of tail ?
  parse-arg                 \ parse next arg from tail

  ( a2 a1 --- )

  swap over -               \ ( source-address count --- )  
  dup #tib !                \ # characters in tib now
  1+ dup +!> >tail          \ advance position by length of arg + space
  tib swap cmove            \ copy arg string to tib
  >in off ;                 \ interpret this word

\ ------------------------------------------------------------------------
\ interpret command line tail

: interptail
  begin
    interpret               \ interpret 1 word from tail
    [ ' refill >body ]      \ did refill get reset to query?
    literal @               \ i.e. did we interpret all args
    ['] query =             \ if not keep interpreting
  until ;

\ ------------------------------------------------------------------------
\ defered word to interpret command line tail

headers>

 defer (doargs)             \ turnkey apps can change how args are handled

<headers

\ ------------------------------------------------------------------------
\ interpret command line tail

: ((doargs))
  off> >tail                \ reset interpret to start of tail
  off> #tail

  argp c@ '-' =             \ is the first arg a - ?
  if
    decr> argc
    2 +!> argp

    ['] arg>tib is refill   \ and interpret the rest
    fixargs
    interptail
  else
    fixargs                 \ might be a list of filenames
  then ; 

 ' ((doargs)) is (doargs)   \ turnkeyd apps might not want args touched

\ ------------------------------------------------------------------------
\ how do you patch a defered word into a defered chain you ask ??? :)

: doargs          ( ---- )
  argc                      \ dont try interpret null args
  if 
    (doargs) 
  then
  defers default ;          \ patch into head of chain

\ ------------------------------------------------------------------------

behead

\ ========================================================================
