;isforth.asm    - isforth main kernel source   (c) 2000+ mark i manning iv
;=========================================================================

bits 32                     ;This field intentionally NOT left blank

%define ver 010ah           ;hi byte = maj ver : lo byte = min ver

;-------------------------------------------------------------------------

%include "macros.1"         ;macros to create headers etc

;-------------------------------------------------------------------------
;bullshit red tape visual clutter

section .text               ;i dont comment on bullshit

 global _start              ; (much :)

_start:
 jmp origin                 ;unavoidable evil forward reference!

;-------------------------------------------------------------------------
;some important variables and constants

 const 'tlist', tlist, 0    ;address of top of list space
 const 'thead', thead, 0    ;address of top of head space
 const 'endp', endp, _end   ;address of end of loaded program space

 const 'arg0', arg0, 0      ;isforths own file name
 const 'argp', argp, 0      ;pointer to os mangled command line tail
 const 'argc', argc, 0      ;number of args passed to isforth
 const 'envp', envp, 0      ;pointer to environment

 const 'termios', tios, 0   ;pointer to termios structure 
 
 var '?inittrm', qinittrm, 0 ;flag: term initialized already ?

 const 'lsp', lsp, 0        ;fload nest stack pointer

 var "'tib", ttib, 0        ;address of tib

 const 'version', version, ver
 const 'turnkeyd', turnkeyd, 0

bhead:      dd 0            ;address of bottom of head space

;-------------------------------------------------------------------------
;the beef (moo!)

 %include "reloc.1"         ;head space relocation (see fsave.f)
 %include "syscalls.1"      ;platform specific (linux/freebsd)
 %include "stack.1"         ;stack manipulation etc
 %include "memory.1"        ;fetching and storing etc
 %include "logic.1"         ;and/or/xor etc
 %include "math.1"          ;basic math functions +/-* etc
 %include "loops.1"         ;looping and branching constructs
 %include "exec.1"          ;word execution, nest/next etc
 %include "io.1"            ;console i/o etc
 %include "compile.1"       ;compilation/creating words
 %include "vocabs.1"        ;vocabulary creation etc

;-------------------------------------------------------------------------

;do not define any words below this point unless they are headerless

;-------------------------------------------------------------------------
;entry point  - 

origin:                     ;sys_brk out to 1m and sys_mprotect to rwx
 mov eax, 02dh              ;we should decide on a good end of memory
 mov ebx, 08148000h         ;and make a stupid equate for it so we can
 int 080h                   ;bury whats going on with obfuscated code!

 mov eax, 07dh              ;sys mprotect
 mov ebx, 08048000h
 mov ecx, 00100000h
 mov edx, 7
 int 080h                   ;make the entire program space rwx

 mov dword [qinittrm+5],0   ;terminal properties not set yet

 pop ebx                    ;get argc
 mov ebp, ebx
 dec ebx                    ;discount arg 0
 inc ebp
 mov dword [argc+5], ebx    ;save arg count
 lea ebx, [esp+ebp*4]
 mov [envp+5], ebx
 pop dword [arg0+5]         ;save pointer to arg0 (our own file name)
 pop dword [argp+5]         ;save pointer to command line tail

;isforths memory runs from 8048000 to 8148000-1

 mov eax, 08147ff8h         ;allocate 1000h bytes of space for each
 mov [sp0+5], eax           ;of the two stacks
 sub eax, 01000h            ;very small so as to discourage the use
 mov [rp0+5], eax           ;of evil recursive functions
 sub eax, 01000h 

;these grow up in memory

 sub eax, 36                ;optimization shmoptimization
 mov [tios+5], eax          ;termios = 9 dwords
 sub eax, 100               ;enough space to nest 5 floads
 mov [lsp+5], eax           ;dont nest floads!!!

 sub eax, 80                ;that is decimal 80 not 128
 mov [ttib+5], eax          ;set address of terminal input buffer

 mov [thead+5], eax         ;top of head space

 mov ebx, [endp+5]          ;point to where headers got loaded in
 mov ecx, eax               ;find distance from _end to top of
 sub ecx, ebx               ;unallocated memory ([ttib+5] -1)
 shr ecx, 1                 ;divide this distance in 2
 sub eax, ecx               ;point eax at the mid point

;splitting the memory evenly between list and head space might not
;be the besst way to go but...

;as my brother always says - share and share alot ;)

 mov [tlist+5], eax         ;address of top of list space

;or as my sister says. its mine. its all mine. everythings mine!

 mov [hp+5], eax            ;address for headers to be relocated to
 mov [bhead], eax           ;needed by fsave
 mov [dp+5], ebx            ;set dictionary pointer (here)

 call unpack                ;relocate headers to allocated head space

 mov ebp, [rp0+5]           ;quit will redo this but if we dont do it
 mov esp, [sp0+5]           ;now init will segfault

 call nest
 dd default                 ;initialize forth
 dd qok, off                ;no ok message
 dd quit                    ;run inner function - never returns to here

;-------------------------------------------------------------------------

;in windows you quit by hitting the start button.  in forth you start
;by jumping to quit :)

;according to the forth tradition the word quit is the main loop of the
;innter interpreter.  i have a slightly modified view of what quit is
;however - to me quit is the inner compiler.  the interpret loop that the
;compiler calls is just a means of interfacing to the compiler and testing 
;that which you compile.  
;
;once development is complete and your new application executable is saved
;out the compiling and creating words are usually never referenced again.  
;in a turnkeyd application where all headers have been stripped out of the 
;target executable it would be silly to make a reference to words like 
;(quit) because that path eventually tries to search the dictionary and in 
;a turnkeyd application there is no dictionary.
;
;in a turnkeyd application quit becomes main.  

;to make a turnketd application in isforth one would do
;
; ' app-main is quit
; turnkey app-filename
;
;when the application is executed app-main will be jumped to after the
;default init chain has finished.  if you do not want anything
;initialized by the isforth kernel you can do ' app-main is default
;instead.

;-------------------------------------------------------------------------
;marks end of code space (where boot will set dp pointing to)

;note:   do not define anything at all below this point 

_end:                       ;when isforth loads, this is where headers are

;=========================================================================
