/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: symbols.c,v 1.5 2002/01/05 19:44:25 cosine Exp $
 */

#include "elfdefs.h"
#include "load.h"
#include "main.h"
#include "symbols.h"

/*
 * libStrn includes
 */
#include "alloc.h"

static struct aSymbol *CreateSymbol();

/*
 * Global: pointer to symbol string table
 */
char                    *SymbolStringTable = 0;

/*
 * Local: linked list of symbols
 */
static struct aSymbol   *SymbolList = 0;

/*
 * Global: total number of symbols in SymbolList
 */
unsigned int            TotalSymbols = 0;

/*
LoadSymbol()
  Called when we load a new file in for debugging and read it's
symbol table. Add the given symbol to our symbol data structure

Inputs: data - symbol data element

Return: none
*/

void
LoadSymbol(void *data)

{
  struct aSymbol *ptr;

  ptr = CreateSymbol();
  ptr->data = data;

  ++TotalSymbols;
} /* LoadSymbol() */

/*
CreateSymbol()
  Allocate space for a new symbol entry in our symbol data structure
and insert it into the structure

Return: pointer to new symbol node
*/

static struct aSymbol *
CreateSymbol()

{
  struct aSymbol *ptr;

  ptr = (struct aSymbol *) MyMalloc(sizeof(struct aSymbol));

  ptr->next = SymbolList;
  SymbolList = ptr;

  return (ptr);
} /* CreateSymbol() */

/*
TraverseSymbols()
  Traverse the symbol data structure and execute a function at
each node

Inputs: func  - function to execute for each node - the "data"
                element of the node is passed to the function
        param - parameter passed to function in addition to "data"

Return: none
*/

void *
TraverseSymbols(int (*func)(void *data, void *arg), void *param)

{
  struct aSymbol *sptr;
  int ret;

  for (sptr = SymbolList; sptr; sptr = sptr->next)
  {
    ret = (*func)(sptr->data, param);
    if (ret == ST_STOP)
      return (sptr->data);
  }

  return (0);
} /* TraverseSymbols() */

/*
FindSymbolAddress()
  Find the address of a symbol given it's name

Inputs: name - name of symbol

Outputs: err - set to 1 if symbol not found

Return: symbol address
*/

unsigned int
FindSymbolAddress(char *name, int *err)

{
  switch (getLoadedFileFormat(mainWorkspace_p->loadWorkspace_p))
  {
    case OT_ELF:
    {
      return (FindElfSymbolAddress(name, err));
      break; /*NOTREACHED*/
    }

    default:
    {
      *err = 1;
      break;
    }
  }

  return (0);
} /* FindSymbolAddress() */
