/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: readln.c,v 1.5 2002/01/08 13:57:34 cosine Exp $
 */

#include <stdio.h>

#include "alddefs.h"
#include "command.h"
#include "defs.h"
#include "misc.h"
#include "print.h"
#include "window.h"

#ifdef HAVE_READLINE_READLINE_H
#include <readline/readline.h>
#endif

#ifdef HAVE_READLINE_HISTORY_H

#include <readline/history.h>

#else

extern void add_history();

#endif /* !HAVE_READLINE_HISTORY_H */

/*
 * libString includes
 */
#include "alloc.h"
#include "Strn.h"

#ifndef HAVE_READLINE

/*
DisplayPrompt()
  Display command prompt
*/

static void
DisplayPrompt()

{
  if (ModeConsole)
  {
    fprintf(stdout,
      "%s",
      mainWorkspace_p->commandWorkspace_p->CmdPrompt);
    return;
  }

#ifdef USE_CURSES

  if (ModeCurses)
    DisplayCursesPrompt();

#endif /* USE_CURSES */

} /* DisplayPrompt() */

#endif /* !HAVE_READLINE */

/*
ReadLine()
  Read a line from stdin and return a pointer to it. FreeLine()
must be called when the calling function is done with the buffer.
*/

char *
ReadLine()

{
  char *ret;
#ifndef HAVE_READLINE
  char buffer[MAXLINE];
#endif

#ifdef HAVE_READLINE

  ret = readline(mainWorkspace_p->commandWorkspace_p->CmdPrompt);

  if (!ret)
  {
    /*
     * EOF occurred (possibly ^D)
     */
    MyExit(1);
  }
  else if (*ret != '\0')
    add_history(ret);

#else

  DisplayPrompt();

  ret = fgets(buffer, MAXLINE, stdin);
  if (ret)
    ret = Strdup(buffer);
  else
  {
    /*
     * Error occured - probably EOF (^D)
     */
    MyExit(1);
  }

#endif /* !HAVE_READLINE */

  return (ret);
} /* ReadLine() */

/*
FreeLine()
  Frees the memory used by 'buf'
*/

void
FreeLine(char *buf)

{
  if (buf)
    MyFree(buf);
} /* FreeLine() */
