/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_write.c,v 1.3 2000/09/20 20:55:09 cosine Exp $
 */

#include <errno.h>
#include <string.h>

#include "alddefs.h"
#include "print.h"
#include "scroll.h"
#include "window.h"

/*
c_write()
  Dump contents of current window to a file

Inputs: av[1] - filename
*/

void
c_write(int ac, char **av)

{
#ifdef USE_CURSES

  char filebuf[MAXLINE];
  FILE *fp;

  if (ac < 2)
    strcpy(filebuf, "ald.out");
  else
    strcpy(filebuf, av[1]);

  if (!(fp = fopen(filebuf, "w")))
  {
    Print(P_ERROR, "Unable to open %s: %s",
      filebuf,
      strerror(errno));
    return;
  }

  if (DumpCurrentWindow(fp))
    Print(P_COMMAND, "Active window dumped to %s", filebuf);

  fclose(fp);

#endif /* USE_CURSES */
} /* c_write() */
