/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_register.c,v 1.3 2000/10/11 14:52:40 cosine Exp $
 */

#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "msg.h"
#include "output.h"
#include "print.h"
#include "registers.h"

/*
 * libDebug includes
 */
#include "debug.h"

/*
c_register()
  Display/manipulate registers

Usage: register [name [value]]
*/

void
c_register(int ac, char **av)

{
  if (ac > 1)
  {
    int rindex;

    /*
     * They want the value of a specific register
     */
    if ((rindex = FindRegister(av[1])) != (-1))
    {
      long value;   /* new register value */
      char *endptr;

      if (ac > 2)
      {
        value = strtol(av[2], &endptr, 0);
        if ((endptr == av[2]) || (*endptr != '\0'))
        {
          /*
           * Invalid number
           */
          Print(P_COMMAND, MSG_INVNUM, av[2]);
          return;
        }

        if (!SetRegister(rindex, value))
        {
          Print(P_ERROR, MSG_PTERR, strerror(errno));
          return;
        }
      }
      else
      {
        int err;

        /*
         * Output the value of the register they are interested
         * in
         */
        UpdateRegisters(rindex);

        err = 0;
        value = (long) NumPrompt("New value (Return for none): ", &err);
        if (!err)
        {
          if (!SetRegister(rindex, value))
          {
            Print(P_ERROR, MSG_PTERR, strerror(errno));
            return;
          }
        } /* if (!err) */
      } /* if (ac <= 2) */
    } /* if ((rindex = FindRegister(av[1])) != (-1)) */
    else
    {
      /*
       * Register was not found
       */
      Print(P_COMMAND, "Invalid register: %s",
        av[1]);
      return;
    }
  }
  else
  {
    /*
     * No arguments - they want a list of all registers
     */
    UpdateRegisters(NOREG);
  }
} /* c_register() */
