/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_lbreak.c,v 1.4 2001/07/14 01:42:44 cosine Exp $
 */

#include <string.h>

#include "print.h"

/*
 * libDebug includes
 */
#include "break.h"

/*
 * libString includes
 */
#include "Strn.h"

/*
c_lbreak()
  List breakpoints
*/

void
c_lbreak(int ac, char **av)

{
  struct Breakpoint *bptr;
  char istr[MAXLINE];

  /*
   * Breakpoints are stored in reverse numerical order, so
   * advance to the end and work backwards
   */
  bptr = Breakpoints;
  while (bptr)
  {
    if (!bptr->next)
      break;
    bptr = bptr->next;
  }

  if (bptr)
  {
    Print(P_COMMAND,
      "%-03s   %-10s   %-07s   %-10s   %-12s",
      "Num",
      "Type",
      "Enabled",
      "Address",
      "IgnoreCount");

    while (bptr)
    {
      if (bptr->ignorecnt)
        Sprintf(istr, "%-12d", bptr->ignorecnt);
      else
        strcpy(istr, "none");

      Print(P_COMMAND,
        "%-03d   %-10s   %-07s   0x%08lX   %-12s",
        bptr->number,
        "Breakpoint",
        (bptr->flags & BK_ENABLED) ? "y" : "n",
        bptr->address,
        istr);

      bptr = bptr->prev;
    }
  } /* if (bptr) */
  else
    Print(P_COMMAND, "No breakpoints or watchpoints set");
} /* c_lbreak() */
