/*
 * libOp
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: disasm.h,v 1.2 2000/10/25 17:38:47 cosine Exp $
 */

#ifndef INCLUDED_disasm_h
#define INCLUDED_disasm_h

#ifndef INCLUDED_config_h
#include "config.h"        /* INTEL86 */
#define INCLUDED_config_h
#endif

/*
 * MAXOPLEN should be set to the maximum number of bytes in
 * one opcode on your architecture.
 */
#ifdef INTEL86
/*
 * Intel's max opcode length is actually 17 bytes I believe, but
 * rounding up cannot hurt.
 */
# define MAXOPLEN  20
#else
#error "Please manually set MAXOPLEN in libOp/include/disasm.h"
#endif

#ifndef MAXLINE
#define MAXLINE   1024
#endif

/*
 * Some flags to be passed to our architecture specific
 * routines
 */
#define OP_BITS32    (1 << 0)  /* use 32 bit data and addressing */

/*
 * Prototypes
 */

long DisAssemble(unsigned char *data, char *output, unsigned int flags);

#endif /* INCLUDED_disasm_h */
