/*
 * libOp
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: prefix-x86.h,v 1.1.1.1 2000/09/11 17:24:21 cosine Exp $
 */

#ifndef INCLUDED_prefix_x86_h
#define INCLUDED_prefix_x86_h

/*
 * The PX_xxx bitmasks represent special characteristics about
 * a particular opcode
 */

#define PX_32BITDATA (1 << 0) /* use 32 bit opcodes over 16 (0x66) */
#define PX_32BITADDR (1 << 1) /* use 32 bit addressing (ModRM) (0x67) */
#define PX_REP       (1 << 2) /* REP prefix (0xF3) */
#define PX_REPE      (1 << 3) /* REPE prefix (0xF3) */
#define PX_REPNE     (1 << 4) /* REPNE prefix (0xF2) */
#define PX_SEGOVER   (1 << 5) /* Segment override prefix */

struct OpCode;

/*
 * Prototypes
 */

unsigned int CheckPrefix(unsigned char *code, unsigned int *flags);
int MatchPrefix(struct OpCode *ptr, unsigned int flags);

/*
 * External declarations
 */

extern unsigned int        PrefixFlags;

#endif /* INCLUDED_prefix_x86_h */
