/*
 * libOp
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: disasm-x86.h,v 1.3 2001/08/19 15:02:56 cosine Exp $
 */

#ifndef INCLUDED_disasm_x86_h
#define INCLUDED_disasm_x86_h

struct OpCode
{
  int name;           /* name of symbolic instruction */
  int OperandCount;   /* number of operands */
  long operands[3];   /* array containing operand types */
  char *mcode;        /* machine code the instruction assembles to */
  int oplen;          /* length of mcode - can't use strlen if \x00's */
  int digit;          /* ModR/M digit if there is one */
  /*
   *  This array is used to store extra information about registers
   * for each operand. Each index of this array corresponds to the
   * same index of operands[]. One use of this array is to represent
   * general registers such as "al". In these cases, the slot in
   * opinfo[] will be the index of Registers[] corresponding to
   * the register we want. Suppose operands[0] requires the al
   * register. It will have the REGISTER bit set, and opinfo[0]
   * will be set to R_AL.
   *  The second use of this array is for the instructions using
   * the control, debug, or fpu registers. If an operand specifically
   * needs fpu(1), it will have the REG_FPU bit set, and the
   * corresponding index of opinfo[] will be set to 1.
   */
  short opinfo[3];
};

/*
 * This is the value the indices of opinfo[] will take on if
 * there is no register number for the opcode
 */
#define NOOPARG  (-1)

/*
 * Size/attributes of the operands
 */

#define BITS8        (1 << 0)
#define BITS16       (1 << 1)
#define BITS32       (1 << 2)
#define BITS48       (1 << 3)  /* ptr16:32 or m16:32 operands */
#define BITS64       (1 << 4)  /* MMX registers */
#define BITS80       (1 << 5)  /* FPU only */
#define BITS128      (1 << 6)  /* XMM registers */
#define FAR          (1 << 7)
#define NEAR         (1 << 8)
#define SHORT        (1 << 9)
#define COLON        (1 << 10) /* operand is followed by colon */
#define TO           (1 << 11)

/*
 * Type of operand: memory, register etc
 */

#define MEMORY       (1 << 12) /* memory location */
#define REGISTER     (1 << 13) /* normal register */
#define IMMEDIATE    (1 << 14) /* immediate byte value */
#define RELATIVE     (1 << 15) /* relative address */
#define REGMEM       (1 << 16) /* byte from register or memory */
#define REG_SR       (1 << 17) /* any segment register */
#define MEMOFFS      (1 << 18) /* address offset */
#define REG_FPU      (1 << 19) /* floating point stack registers */
#define REG_MMX      (1 << 20) /* 64 bit mmx register */
#define REG_XMM      (1 << 21) /* Katmai xmm register */
#define CONSTANT     (1 << 22) /* a numerical constant */
#define SIBBYTE      (1 << 23) /* opcode requires a SIB byte */
#define SEG16        (1 << 24) /* 16 bit segment size */
#define OFF16        (1 << 25) /* 16 bit segment offset size */
#define OFF32        (1 << 26) /* 32 bit segment offset size */

#define REG8         (REGISTER | BITS8)
#define REG16        (REGISTER | BITS16)
#define REG32        (REGISTER | BITS32)

/*
 * Placed in the 'digit' field of Instructions[] if the opcode
 * is defined with a /r in the Intel instruction set reference -
 * make sure this is greater than 7, since the digits range from
 * 0 to 7. This indicates that the ModR/M byte of the instruction
 * contains both a register and r/m operand.
 */
#define REGRM        8

/*
 * Placed in the 'digit' field of Instructions[] if the opcode
 * is defined with a +rb, +rw, or +rd, meaning the opcode is
 * increased by a value from 0-7 representing a specific register.
 * See table 3.1 in the Intel instruction set reference.
 */
#define REGCODE      9

/*
 * Placed in the 'digit' field of Instructions[] if the opcode
 * is defined with a +i, meaning the opcode is increased by a value
 * from 0-7 representing a specific floating point stack register.
 */
#define FPUCODE      10

/*
 * Registers
 */
enum
{
  R_AH,
  R_AL,
  R_AX,
  R_BH,
  R_BL,
  R_BP,
  R_BX,
  R_CH,
  R_CL,
  R_CR0,
  R_CR2,
  R_CR3,
  R_CR4,
  R_CS,
  R_CX,
  R_DH,
  R_DI,
  R_DL,
  R_DR0,
  R_DR1,
  R_DR2,
  R_DR3,
  R_DR4,
  R_DR5,
  R_DR6,
  R_DR7,
  R_DS,
  R_DX,
  R_EAX,
  R_EBP,
  R_EBX,
  R_ECX,
  R_EDI,
  R_EDX,
  R_ES,
  R_ESI,
  R_ESP,
  R_FS,
  R_GS,
  R_MM0,
  R_MM1,
  R_MM2,
  R_MM3,
  R_MM4,
  R_MM5,
  R_MM6,
  R_MM7,
  R_SI,
  R_SP,
  R_SS,
  R_ST0,
  R_ST1,
  R_ST2,
  R_ST3,
  R_ST4,
  R_ST5,
  R_ST6,
  R_ST7,
  R_TR3,
  R_TR4,
  R_TR5,
  R_TR6,
  R_TR7,
  R_XMM0,
  R_XMM1,
  R_XMM2,
  R_XMM3,
  R_XMM4,
  R_XMM5,
  R_XMM6,
  R_XMM7
};

/*
 * Prototypes
 */

long x86DisAssemble(unsigned char *data, char *output,
                    unsigned int flags);

struct ModSib;

/*
 * External declarations
 */

extern struct OpCode     **OpCodes[];
extern char              *InstructionNames[];

extern unsigned char     *ModRMOffset;
extern struct ModSib     *ModRMPtr;
extern unsigned char     *SibOffset;
extern struct ModSib     *SibPtr;
extern int               RegisterCode;
extern int               FPUCode;
extern int               SegmentOverride;

#endif /* INCLUDED_disasm_x86_h */
