/*
 * libDebug
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: debug.h,v 1.8 2001/04/26 23:11:45 cosine Exp $
 */

#ifndef INCLUDED_debug_h
#define INCLUDED_debug_h

#ifndef INCLUDED_sys_types_h
#include <sys/types.h>        /* pid_t */
#define INCLUDED_sys_types_h
#endif

/*
 * Indicates there is no process currently being traced
 */
#define NOPID     (-1)

#ifndef MAXLINE
#define MAXLINE   1024
#endif

/*
 * Prototypes
 */

void InitializeDebugProcess(char *path, int redirect);
char **GetAllRegisters(int *count, int regindex);
int SingleStepInto(int num, int *data);
int SingleStepOver(int num, int *data);
int ContinueDebugProcess(int *data);
int FindRegister(char *name);
int SetRegister(int regindex, long value);
long GetRegister(int regindex);
long DumpMemory(char **buf, unsigned long start, long bytes);
int SetMemory(unsigned long address, unsigned long value);
unsigned long GetInstructionAddress();
int FindDebugProcess();
void EndDebugProcess();
char *GetDebugOutput();

/*
 * External declarations
 */

extern pid_t             DebugPid;
extern int               ProcessRunning;
extern unsigned long     InstructionPointer;
extern int               RedirectIO;
extern int               Pipes[2];
extern char              DebugOutput[MAXLINE];

#endif /* INCLUDED_debug_h */
