/*
 * libDebug
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: regs-x86.h,v 1.4 2000/09/21 20:07:21 cosine Exp $
 */

#ifndef INCLUDED_regs_x86_h
#define INCLUDED_regs_x86_h

#ifndef INCLUDED_config_h
#include "config.h"         /* *BSD, Linux */
#define INCLUDED_config_h
#endif

struct x86RegInfo
{
  char *name;           /* register name */

#if defined(FreeBSD)

  unsigned int *valptr; /* pointer to location of register contents */

#elif defined(OpenBSD)

  int *valptr;

#elif defined(Linux)
  
  long *valptr;

#endif

  /*
   * This value indicates the "chunk" position starting from
   * the right. What I mean by "chunk" is a group of eight
   * bits.
   *
   * For example, consider the eax register:
   *
   * eax     ax/ah                         al
   * b31 ... b15 b14 b13 b12 b11 b10 b9 b8 b7 b6 b5 b4 b3 b2 b1 b0
   *
   * The position of ah is 2, since it is 2 groups of eight bits
   * away from bit 0. The position of al is 1 since it is 1 group
   * of eight bits from bit 0. eax is position 4 and ax is position
   * 2.
   *
   * This serves a purpose when we want to modify ah or al only
   * so in our array we know what position that particular
   * register starts at.
   */
  int position;

  unsigned int flags; /* R_xxx bitmasks */
};

/*
 * Register flags
 */
#define R_BITS8       (1 << 0) /* 8 bit register */
#define R_BITS16      (1 << 1) /* 16 bit register */
#define R_BITS32      (1 << 2) /* 32 bit register */
#define R_NODISPLAY   (1 << 3) /* do not output register/value */

#endif /* INCLUDED_regs_x86_h */
