/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: main.h,v 1.3 2002/01/02 18:51:51 cosine Exp $
 */

#ifndef INCLUDED_main_h
#define INCLUDED_main_h

#include "command.h"
#include "disassemble.h"
#include "load.h"
#include "print.h"
#include "terminal.h"

struct aldWorkspace
{
  char *filename;         /* command line filename, if any */

  struct commandWorkspace *commandWorkspace_p;
  struct disassembleWorkspace *disassembleWorkspace_p;
  struct loadWorkspace *loadWorkspace_p;
  struct printWorkspace *printWorkspace_p;
  struct terminalWorkspace *terminalWorkspace_p;
};

/*
 * Prototypes
 */

struct aldWorkspace *initALD(int argc, char *argv[]);
void termALD(struct aldWorkspace *ws);
void procALD(struct aldWorkspace *ws);

/*
 * External declarations
 */

extern struct aldWorkspace *mainWorkspace_p;

extern int ModeConsole;
extern int ModeCurses;
extern int PlatformEndian;

#endif /* INCLUDED_main_h */
