/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: load.h,v 1.5 2002/01/05 19:44:23 cosine Exp $
 */

#ifndef INCLUDED_load_h
#define INCLUDED_load_h

#ifndef INCLUDED_stdio_h
#include <stdio.h>            /* FILE* */
#define INCLUDED_stdio_h
#endif

#ifndef INCLUDED_sys_types_h
#include <sys/types.h>        /* size_t */
#define INCLUDED_sys_types_h
#endif

#ifndef INCLUDED_aout_h
#include "aout.h"             /* struct aoutWorkspace */
#define INCLUDED_aout_h
#endif

#ifndef INCLUDED_elfdefs_h
#include "elfdefs.h"          /* struct elfWorkspace */
#define INCLUDED_elfdefs_h
#endif

struct loadParameters
{
  unsigned int virtualFileAddress;      /* virtual address of file beginning */
  unsigned int virtualEntryPoint;       /* virtual address of entry point */
  unsigned int entryPoint;              /* entry point of object file */

  unsigned int objectFileOffset;        /* file offset */
  unsigned int virtualObjectFileOffset; /* virtual address of current offset */
};

struct loadWorkspace
{
  void *MapPtr;                          /* pointer to mapped memory */
  size_t MappedSize;                     /* size of mapped memory */

  int objectFileDescriptor;              /* file we are debugging */
  char *objectFileName;                  /* name of file we are debugging */
  int objectFileFormat;                  /* object file format (OT_xxx) */

  struct loadParameters params;          /* object file parameters */

  struct aoutWorkspace *aoutWorkspace_p; /* aout workspace pointer */
  struct elfWorkspace *elfWorkspace_p;   /* elf workspace pointer */
};

/*
 * Object types
 */

#define OT_UNKNOWN  1  /* unknown object format */
#define OT_ELF      2  /* Executable and Linkable Format (ELF) */
#define OT_AOUT     3  /* a.out format */

/*
 * Prototypes
 */

struct loadWorkspace *initLoad();
void termLoad(struct loadWorkspace *ws);
void clearLoadParameters(struct loadParameters *params);
int procLoad(struct loadWorkspace *ws, char *filename, int redirect);
void procUnload(struct loadWorkspace *ws);

char *getLoadedFileName(struct loadWorkspace *ws);
int getLoadedFileFormat(struct loadWorkspace *ws);
unsigned int getLoadedVirtualFileAddress(struct loadWorkspace *ws);
unsigned int getLoadedVirtualEntryPoint(struct loadWorkspace *ws);
unsigned int getLoadedEntryPoint(struct loadWorkspace *ws);
unsigned int getLoadedFileOffset(struct loadWorkspace *ws);
unsigned int getLoadedVirtualFileOffset(struct loadWorkspace *ws);
void setLoadedVirtualFileAddress(struct loadWorkspace *ws, unsigned int address);
void setLoadedVirtualEntryPoint(struct loadWorkspace *ws, unsigned int address);
void setLoadedEntryPoint(struct loadWorkspace *ws, unsigned int address);
void setLoadedFileOffset(struct loadWorkspace *ws, unsigned int offset);
void setLoadedVirtualFileOffset(struct loadWorkspace *ws, unsigned int offset);
void incLoadedVirtualFileOffset(struct loadWorkspace *ws, unsigned int amt);

/*
 * External declarations
 */

extern char           *EndianType[];
 
#endif /* INCLUDED_load_h */
