/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: disassemble.h,v 1.4 2001/12/31 23:09:01 cosine Exp $
 */

#ifndef INCLUDED_disassemble_h
#define INCLUDED_disassemble_h

#ifndef INCLUDED_defs_h
#include "defs.h"        /* USE_CURSES */
#define INCLUDED_defs_h
#endif

struct disassembleWorkspace
{
  unsigned long NextInstruction;    /* address of next instruction */

  unsigned int CurrentSectionStart; /* start address of current section */

  unsigned int flags;               /* flags passed to DisAssemble() */
};

/*
 * Prototypes
 */

struct disassembleWorkspace *initDisassemble();
void termDisassemble(struct disassembleWorkspace *ws);
long procDisassemble(struct disassembleWorkspace *ws, unsigned char *data,
                     unsigned int address, unsigned int owin);
void DisplayNextInstruction();

/*
 * External declarations
 */
extern unsigned int            DisassembleFlags;

#endif /* INCLUDED_disassemble_h */
