/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: command.h,v 1.13 2001/12/31 23:09:01 cosine Exp $
 */

#ifndef INCLUDED_command_h
#define INCLUDED_command_h

#ifndef INCLUDED_setjmp_h
#include <setjmp.h>        /* jmp_buf */
#define INCLUDED_setjmp_h
#endif

#include "main.h"          /* struct aldWorkspace */
struct aldWorkspace;

struct Command
{
  char *cmd;          /* command name */
  void (* funcptr)(); /* function to call */
  unsigned int flags; /* C_xxx bitmasks */
};

struct commandWorkspace
{
  char *CmdPrompt;            /* command prompt string */
  jmp_buf CmdParserEnv;       /* environment for procCommand() */
};

/*
 * Various command bitmasks
 */
#define C_ALIAS      (1 << 0) /* command is an alias for another */
#define C_CURSES     (1 << 1) /* curses-mode only command */
#define C_FILELOADED (1 << 2) /* needs a file loaded (via "load") */
#define C_AMBIGUOUS  (1 << 3) /* command is ambiguous */
#define C_PTRACE     (1 << 4) /* command uses ptrace call */

/*
 * Prototypes
 */

struct commandWorkspace *initCommand();
void termCommand(struct commandWorkspace *ws);
void procCommand(struct aldWorkspace *main_p);

struct Command *FindCommand(struct Command *cmdlist, char *name,
                            unsigned int *flags);

void c_break(int ac, char **av);
void c_clear(int ac, char **av);
void c_continue(int ac, char **av);
void c_delete(int ac, char **av);
void c_disable(int ac, char **av);
void c_disassemble(int ac, char **av);
void c_enable(int ac, char **av);
void c_enter(int ac, char **av);
void c_examine(int ac, char **av);
void c_file(int ac, char **av);
void c_help(int ac, char **av);
void c_ignore(int ac, char **av);
void c_lbreak(int ac, char **av);
void c_load(int ac, char **av);
void c_next(int ac, char **av);
void c_quit(int ac, char **av);
void c_register(int ac, char **av);
void c_run(int ac, char **av);
void c_set(int ac, char **av);
void c_step(int ac, char **av);
void c_tbreak(int ac, char **av);
void c_unload(int ac, char **av);
void c_window(int ac, char **av);
void c_write(int ac, char **av);

#endif /* INCLUDED_command_h */
