/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#ifdef XAW
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#endif /* XAW */
#ifdef XAWPLUS
#include <X11/XawPlus/Paned.h>
#include <X11/XawPlus/Box.h>
#include <X11/XawPlus/Command.h>
#endif /* XAWPLUS */

#include "struct.h"
#include "config.h"


/*
 * Global variables
 */

extern	Cursor	def_cursor;
extern	Cursor	file_cursor;

extern	Widget	toplevel;
extern	Widget	FileM;
extern	Boolean	MMENU_MARK;
extern	Widget	mpopup_shell;
extern	Widget	mpopup_pane;

extern	Widget	text_1, text_2;		/* Zum Verschieben braucht man 2 Text,
					   sonst nur einen */

extern	Folder_Glyph	*selc_fo;
extern	Dir_Glyph	*selc_g;
extern	Dimension	selc_f;
extern	Dir_Glyph	root;

extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs;
extern	Dimension	multi_ve;

extern	xfm_struct	defaults;

Widget			popup_shell = NULL;
Widget			custom_menu = NULL;
Widget			custom_button;
Widget			popup_pane;

static	XtTranslations	popup_trans = NULL;
static	XtTranslations	custom_trans = NULL;
static	XtTranslations	enterbut_trans = NULL;
static	XtTranslations	enterbox_trans = NULL;
Boolean			MENU_MARK;
static	int		shown;

typedef	struct {
	char	*label;
	char	*cmd;
	Boolean	can_selected;
} Custom_Glyph;

Dimension		custom_count = 0;
Custom_Glyph		**custom = NULL;

/*
 * Function Prototypes
 */
extern	void	start_edit (void);
extern	void	start_move (void);
extern	void	start_copy (void);
extern	void	start_delete (void);
extern	void	start_exec (void);
extern	void	start_quit (void);
extern	void	start_newdir (void);
extern	void	start_info (void);
extern	void	start_about (void);
extern	void	start_goto (void);
extern	void	start_root (void);
#ifndef COHERENT
extern	void	start_link (void);
#endif

char	*getString(void);

XtActionProc	startPopup (Widget w, XButtonEvent *e,
			    String *s, Cardinal *c);
XtActionProc	hidePopup  (Widget w, XEvent *e,
			    String *s, Cardinal *c);
void		readMenu   (void);
void		startExecPopup (Widget w, XtPointer client, XtPointer call);


/*********************************************************
 * name:	startPopup
 * description:	Darstellen des Popupmenu-Fensters
 * input:	das uebliche fuer einen Event. Gebraucht
 *		wird nur der XButtonEvent-Pointer
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
XtActionProc	startPopup (Widget w, XButtonEvent *e, String *s, Cardinal *c)
{
	Widget	pane, box;
	Widget	button;

	MENU_MARK = FALSE;
	if (popup_shell)
		XtDestroyWidget(popup_shell);
	if (!popup_trans) {
		popup_trans = XtParseTranslationTable("<Leave>: hide-popup()");
		enterbut_trans = XtParseTranslationTable("<Enter>: highlight()");
		enterbut_trans = XtParseTranslationTable("<Btn1Down>: start-custom() hide-popup()");
	}
	popup_shell = XtVaCreatePopupShell("popup_shell",overrideShellWidgetClass,
						toplevel,
						XtNx,((e->x_root - 50)/30)*30,
						XtNy,((e->y_root - 100)/30)*30,
						NULL);
	XtOverrideTranslations(popup_shell,popup_trans);

	/* standard-menu */
	box = XtVaCreateManagedWidget("popup_box",boxWidgetClass,
						popup_shell,
						NULL);
	pane = XtVaCreateManagedWidget("popup_pane",panedWidgetClass,
						box,
						NULL);
	popup_pane = box;

	/* Userdefined menu */
	button = XtVaCreateManagedWidget("menu_button",commandWidgetClass,
					pane,
					XtNshowGrip,FALSE,
					XtNlabel,"Send To:",
					NULL);
	XtOverrideTranslations(button,enterbut_trans);
	custom_button = button;

	button = XtVaCreateManagedWidget("edit_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("Edit File"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_edit,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("move_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,(multi_fo ? "Move Files" : "Move File"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_move,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("copy_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,(multi_fo ? "Copy Files" : "Copy File"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_copy,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("delete_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,(multi_fo ? "Delete Files" : "Delete File"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_delete,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	if (!multi_fo) {
		button = XtVaCreateManagedWidget("exec_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,"Executor",
						NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_exec,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);
		button = XtVaCreateManagedWidget("link_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,"Create Link",
						NULL);	
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_link,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,"New Directory",
						NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_newdir,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		if (selc_g || (selc_fo && selc_f < 16000)) {
			button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
							pane,
							XtNshowGrip,FALSE,
							XtNlabel,"File Info",
							NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) start_info,NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		}
	}

	XtManageChild(popup_shell);
}

/*********************************************************
 * name:	hidePopup
 * description:	Verstecken des popup-menus
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
XtActionProc	hidePopup (Widget w, XEvent *e, String *s, Cardinal *c)
{
	if (w == popup_pane) {
		MENU_MARK = FALSE;
		if (custom_menu)
			XtUnmanageChild(custom_menu);
	}
	else if (!MENU_MARK) {
		if (popup_shell)
			XtDestroyWidget(popup_shell);
		popup_shell = NULL;
		if (custom_menu)
			XtDestroyWidget(custom_menu);
		custom_menu = NULL;
	}
	else if (MENU_MARK && (w == custom_menu)) {
		XtUnmanageChild(custom_menu);
		MENU_MARK = FALSE;
	}
	if (w == mpopup_pane) {
		MMENU_MARK = FALSE;
	}
	else if (!MMENU_MARK) {
		if (mpopup_shell) {
			XtDestroyWidget(mpopup_shell);
			mpopup_shell = NULL;
		}
	}
}

XtActionProc	startSento (Widget w, XEnterWindowEvent *e, String *s, Cardinal *c)
{
	char cmdstr[256];
	sprintf(cmdstr,"sendto %s &",getString());
	SYSTEM(cmdstr);
}

/*********************************************************
 * name:	startExecPopup
 * description:	ausfuehren eines custom-popup-entries.
 * input:	nur den command-string;
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
void	startExecPopup (Widget w, XtPointer client, XtPointer call)
{
	char	*cmd = (char *) client;
	Arg	args[1];
	char	buf[1024];

	if (strstr(cmd,"%s")) {
		char	*got = getString();
		if (got)
			sprintf(buf,cmd,got);
		else
			sprintf(buf,cmd,"");
		exec_exec(buf,NULL);
	}
	else
	exec_exec(cmd,NULL);
	MENU_MARK = FALSE;
}
