/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#ifdef XAW
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#endif /* XAW */
#ifdef XAWPLUS
#include <X11/XawPlus/Form.h>
#include <X11/XawPlus/Box.h>
#include <X11/XawPlus/Command.h>
#include <X11/XawPlus/Paned.h>
#include <X11/XawPlus/SimpleMenu.h>
#include <X11/XawPlus/MenuButton.h>
#include <X11/XawPlus/SmeLine.h>
#include <X11/XawPlus/SmeBSB.h>
#endif /* XAWPLUS */

#include "Clock.h"
#include "struct.h"
#include "config.h"

/*
 * Ein Typedef fuer die Menus
 */
typedef struct {
	char		*label;
	void  (*cb)();
} Menu_Glyph, *Menu_Glyph_Ptr;


/*
 * Global variables
 */

extern	Cursor	def_cursor;
extern	Cursor	file_cursor;

extern	Widget	toplevel;

extern	Folder_Glyph	*selc_fo;
extern	Dir_Glyph	*selc_g;
extern	Dimension	selc_f;
extern	Dir_Glyph	root;

extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs;
extern	Dimension	multi_ve;

extern	xfm_struct	defaults;
extern	Boolean		MULTI;

/*
 * Function Prototypes
 */
extern	void	init_move (char *from, char *to);
extern	void	init_delete (char *file);
extern	void	init_newdir (char *file);
extern	void	init_copy (char *from, char *to);
extern	void	init_setup (Dir_Glyph *dir, File_Glyph *file);
extern	void	init_exec (char *file, char *data);
extern	void	init_info (void);
extern	void	init_goto (void);
extern	void	init_root (void);
extern	void	initAbout (void);
extern	XtActionProc	hidePopup (Widget w, XEvent *e, String *s, Cardinal *c);

void	makeMenu (Widget parent);
XtActionProc	startMPopup (Widget w, XButtonEvent *e, String *s, Cardinal *c);

void	start_edit (void);
void	start_move (void);
void	start_copy (void);
void	start_delete (void);
void	start_exec (void);
void	start_quit (void);
void	start_newdir (void);
void	start_info (void);
void	start_about (void);
void	start_goto (void);
void	start_root (void);
#ifndef COHERENT
void	start_link (void);
extern	void	init_link (char *from, char *to);
#endif
extern	String	getPath(Dir_Glyph *dir);
char	*getString(void);
char	*getMulti(void);
extern	void	makeIconBar (Widget parent, Widget left, Boolean HIDE);


/*
 * Hier stehen die Menus
 */
Menu_Glyph	main_menu[] = {
	{"Execute ...",		start_exec},
#ifndef COHERENT
	{"Create Link",		start_link},
#endif
/*	{"LINE",		NULL},
	{"Show Dir",		start_goto},
	{"Change Root",		start_root},
*/	{"LINE",		NULL},
	{"About",		start_about},
	{"Quit",		start_quit},
	{NULL,			NULL},
};

Menu_Glyph	setup_menu[] = {
	{"Associate Filetype",	NULL},
	{"LINE",		NULL},
	{"Configuration",	NULL},
	{NULL,			NULL},
};

String		menun[] = {"File"}; /*"Setup"}; */
Menu_Glyph_Ptr	menus[] = {main_menu}; /*,setup_menu};*/
Widget			mpopup_pane;
Widget			mpopup_shell = NULL;
Widget			FileM;

static	XtTranslations	mpopup_trans = NULL;
static	XtTranslations	enterbut_trans = NULL;
static	XtTranslations	enterbox_trans = NULL;
Boolean			MMENU_MARK;

/*
**	Function name : makeMenu
**
**	Description : erzeugt auf einem Parent eine Form, in der
**			das Controlmenu gesetzt wird.
**	Input : Widget	parent	- Zeiger auf das Parentwidget
**	Ouput : none
*/
void makeMenu (Widget parent)
{
	Widget	form;
	Widget	last;
	Arg	args[10];
	int	i;

	/*
	 * Erst die Widgetform erzeugen
	 */
	XtSetArg(args[0],XtNshowGrip, TRUE);
	form = XtCreateManagedWidget ("menu_form", formWidgetClass,
					parent, args, 1);

	last = NULL;
	for (i = 0; i < XtNumber(menun); i++) {
		char	*buf;
		char	*nbuf;
		int	j;
		Widget	menu;
		Widget	but;
		Menu_Glyph	*mm;

		/*
		 * Zunaechst einmal den Menubutton erzeugen
		 */
		if (!(buf = (char *) malloc (30)) ||
		    !(nbuf = (char *) malloc (30)))
			FATAL_ERROR ("makeMenu: Malloc failed\n");
		sprintf(buf,"%s_menu",menun[i]);
		sprintf(nbuf,"%s_button",menun[i]);

		XtSetArg(args[0],XtNfromHoriz, last);
		XtSetArg(args[1],XtNlabel, menun[i]);
		XtSetArg(args[2],XtNmenuName,buf);
		XtSetArg(args[3],XtNtop,XtChainTop);
		XtSetArg(args[4],XtNbottom,XtChainTop);
		XtSetArg(args[5],XtNright,XtChainLeft);
		XtSetArg(args[6],XtNleft,XtChainLeft);
		XtSetArg(args[7],XtNwidth,60);
		XtSetArg(args[8],XtNheight,25);

		FileM = XtCreateManagedWidget ("File", commandWidgetClass,
					     form, args, 9);

		XtAddCallback (FileM, XtNcallback,
				(XtCallbackProc) startMPopup,
				NULL);

		last = FileM;
	}
	makeIconBar(form,last,FALSE);
	XtVaCreateManagedWidget("clock",clockWidgetClass, form,
				XtNwidth, 34,
				XtNheight, 34,
				XtNleft, XawChainRight,
				XtNright, XawChainRight,
				XtNtop, XawChainTop,
				XtNbottom, XawChainBottom,
				XtNhorizDistance, (defaults.multi_window ? 360 : 360),
				XtNshapeWindow, FALSE,
				NULL);
}


/*********************************************************
 * name:	startMPopup
 * description:	Darstellen des Popupmenu-Fensters
 * input:	das uebliche fuer einen Event. Gebraucht
 *		wird nur der XButtonEvent-Pointer
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
XtActionProc	startMPopup (Widget w, XButtonEvent *e, String *s, Cardinal *c)
{
	Widget	pane, box;
	Widget	button;
	Display *CurDpy;
	Position xin,yin;

	MMENU_MARK = TRUE;
	if (mpopup_shell)
		XtDestroyWidget(mpopup_shell);
	if (!mpopup_trans) {
		mpopup_trans = XtParseTranslationTable("<Leave>: hide-popup()");
		enterbox_trans = XtParseTranslationTable("<Enter>: hide-popup()");
		enterbut_trans = XtParseTranslationTable("<Enter>: highlight()");
	}
	CurDpy = XtDisplay(FileM);
	XtTranslateCoords(FileM,0,0,&xin,&yin);

	mpopup_shell = XtVaCreatePopupShell("mpopup_shell",overrideShellWidgetClass,
						toplevel,
						XtNallowShellResize, FALSE,
						XtNx,xin - 10,
						XtNy,yin + 30,
						NULL);
	XtOverrideTranslations(mpopup_shell,mpopup_trans);

	/* standard-menu */
	box = XtVaCreateManagedWidget("mpopup_box",boxWidgetClass,
						mpopup_shell,
						NULL);
	pane = XtVaCreateManagedWidget("mpopup_pane",panedWidgetClass,
						box,
						NULL);
	mpopup_pane = box;
	XtOverrideTranslations(mpopup_pane,enterbox_trans);

/*	button = XtVaCreateManagedWidget("mcancel_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("CANCEL"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);
*/
	button = XtVaCreateManagedWidget("mexec_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("Execute..."),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_exec,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("mcreate_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("Create Link..."),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_link,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("mabout_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("About"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_about,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	button = XtVaCreateManagedWidget("mquit_button",commandWidgetClass,
						pane,
						XtNshowGrip,FALSE,
						XtNlabel,("Quit"),
						NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) start_quit,NULL);
	XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	XtManageChild(mpopup_shell);
}

/*********************************************************
 * name:	getString
 * description:	gibt den vollen Filenamen der selection zurueck
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
char	*getString(void)
{	char	*from = NULL;

	if (selc_g || (selc_fo && selc_f < 16000)) {
		if (selc_g)
			from = getPath(selc_g);
		else {
			char *got = getPath(selc_fo->dir);

			if (!(from = (char *) malloc (strlen(got) + 4 +
						      strlen (selc_fo->file[selc_f]->name))))
				FATAL_ERROR("start_delete: Malloc faileed\n");
			if (strcmp(got,"/"))
				sprintf(from,"%s/%s",got,selc_fo->file[selc_f]->name);
			else
				sprintf(from,"/%s",selc_fo->file[selc_f]->name);
			free(got);
		}
	}
	return(from);
}


/*********************************************************
 * name:	getMulti
 * description:	Auslesen des Mutliarrays
 * input:	none	
 * output:	char	*multi-string
 * author:	Ove Kalkan
 * date:	3.8.1993
 *********************************************************/
char	*getMulti(void)
{	char	*back = NULL;

	if (!(back = (char *) malloc(1)))
		FATAL_ERROR("GetMulti: Malloc failed");
	*back = '\0';
	if (multi_fo && multi_vs < 16000 && multi_ve < 16000) {
		int	i;
		char	*got;
		got = getPath(multi_fo->dir);

		for (i = multi_vs; i <= multi_ve; i++) {
			if (!(back = (char *) realloc((void *) back, strlen(back) +
				strlen(got) + strlen(multi_fo->file[i]->name) + 2)))
				FATAL_ERROR("GetMulti: realloc failed.");
			if (strcmp(got,"/"))
				sprintf(back,"%s%s/%s\n",back,got,multi_fo->file[i]->name);
			else
				sprintf(back,"%s/%s\n",back,multi_fo->file[i]->name);
		}
		free(got);
		MULTI = TRUE;
	}
	return(back);
}

/*********************************************************
 * name:	start_edit
 * description:	Edit current file
 * input:	none
 * output:	none
 * author:	Terry Loveall
 * date:	26.5.02
 *********************************************************/
void	start_edit (void)
{
	char	*from = NULL;
	char cmdstr[256];

	from = getString();
	if (from) {
		sprintf(cmdstr,"edx %s &",from);
		SYSTEM(cmdstr);
	}
	free(from);
}


/*********************************************************
 * name:	start_move
 * description:	Ruft die init_move routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_move (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getMulti();
	init_move(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_copy
 * description:	Ruft die init_copy routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_copy (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getMulti();
	init_copy(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_delete
 * description:	Ruft die init_delete routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_delete (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getMulti();
	init_delete(from);
	free(from);
}


/*********************************************************
 * name:	start_newdir
 * description:	Ruft die init_newdir routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_newdir (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getPath (&root);
	init_newdir(from);
	free(from);
}



/*********************************************************
 * name:	start_exec
 * description:	Ruft die init_exec routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 ********************************************************/
void	start_exec (void)
{
	char	*from = NULL;

	from = getString();
	init_exec(from,NULL);
	if (from)	free(from);
}


/*********************************************************
 * name:	start_quit
 * description:	Ruft die init_quit
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_quit (void)
{
	init_quit();
}

/*********************************************************
 * name:	start_about
 * description:	Ruft die initAbout routine
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.93
 *********************************************************/
void	start_about (void)
{
	initAbout();
}

/*********************************************************
 * name:	start_info
 * description:	ruft init_info auf
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.1993
 *********************************************************/
void	start_info(void)
{
	if (selc_g || (selc_f && selc_fo))
		init_info();
}

/*********************************************************
 * name:	start_goto
 * description:	displays the goto-requester
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_goto(void)
{
	init_goto ();
}


/*********************************************************
 * name:	start_root
 * description:	displays the change_root-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_root(void)
{
	init_root();
}

#ifndef COHERENT
/*********************************************************
 * name:	start_link
 * description:	aufrufen von init_link
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	Friday,13th.Aug.1993
 *********************************************************/
void	start_link(void)
{
	char	*file = getString();

	init_link(NULL,file);
}
#endif
