/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#ifdef ISC
#define	_POSIX_SOURCE
#endif

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>

#ifdef NODIRENT
#include <sys/dir.h>
#else
#include <dirent.h>
#endif

#include <X11/X.h>
#include <X11/cursorfont.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#ifdef XAW
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Label.h>
#endif /* XAW */
#ifdef XAWPLUS
#include <X11/XawPlus/Paned.h>
#include <X11/XawPlus/Form.h>
#include <X11/XawPlus/Viewport.h>
#include <X11/XawPlus/Simple.h>
#include <X11/XawPlus/Label.h>
#endif /* XAWPLUS */


#include "struct.h"
#include "config.h"

#ifdef	HAS_QUOTA
#if defined(hpux) || defined(ultrix)
#include <sys/quota.h>
#endif
#ifdef linux
#endif
#endif

#ifndef SIGCHLD
#ifdef SIGCLD
#define	SIGCHLD SIGCLD
#endif
#endif

#ifndef MYSIGTYPE
#define	MYSIGTYPE	void
#endif

/*
 * Globale Variablen
 */


Widget		toplevel,		/* Das toplevel Widget */
		dir_vp,
		dir_area,		/* Die Area in die der Diretorybaum gezeichnet
					   wird */
#ifdef HAS_QUOTA
		quota_label,		/* Der Label fuer die Quotas */
#endif
		dir_vp;			/* Viewport fuer das dir_area Window */

XtAppContext	app_context;		/* Der ApplicationContext - wichtig
					   fuer den periodischen Directory Scan */
Dir_Glyph	root;			/* Das Root-Glyphe */

typedef	Folder_Glyph	*Folder_Glyph_P;

Folder_Glyph	*folder = NULL;		/* Der gerade angewaehlte folder */
Folder_Glyph_P	folders[MAX_FOLDERS];/* Die Foldersliste - 50 muesste reichen */
Dimension	folder_count = 0;	/* Einen gibts immer */

GC		line_gc;		/* Die GC fuer die Linien */
GC		back_gc;		/* Die GC fuer den Background */
GC		selc_gc;		/* Die GC fuer den Background */
GC		white_gc;		/* Die GC fuer den Background */

Boolean		DIR_CHANGED = FALSE;	/* Bildhintergrund refreshen */
Boolean		FILE_CHANGED = FALSE;	/* Bildhintergrund refreshen */

Dimension	last_y = 16000;		/* Fuer die MotionEvents */
Dir_Glyph	*last_g = NULL;
Dimension	last_v = 16000;		/* Fuer die Motionevents in der File-liste */

Dir_Glyph	*grab_g = NULL;		/* Gerade gegrabbte Glyph im Dir-Feld */
File_Glyph	*grab_f = NULL;

Dir_Glyph	*selc_g = NULL;		/* Das gerade angewaehlte Item */
Dimension	selc_f = 16000;
Time		selc_t = 0;		/* Timer fuer den Doppelclick */

Dimension	multi_vs = 16000;	/* Fuer Multigrabs */
Dimension	multi_ve = 16000;

Boolean		GRAB = FALSE;			/* Wenn ein Grab stattfindet */

Cursor		def_cursor;		/* Normaler Cursor */
Cursor		file_cursor;		/* Cursor fuer File-Grab */
Cursor		busy_cursor;		/* BusyCursor */

Atom		wm_delete_window;	/* Atom zum Abfangen des Closebuttons */
int		label_height, 		/* Hoehe des Folder.labels */
		vp_width;		/* Breite des Dir-Viewports */
/*
 * Resources einbinden in resources.h
 */
#include "resources.h"


/*
 * Die ganzen Pixmaps - vorerst noch in diesem Stil, spaeter mit indizierten
 * Feldern, wenn das Associating umgestellt wird.
 */
Pixmap		File_Root_PM;	/* Fur .. Dirs */
Pixmap		File_Plain_PM;	/* Fuer unbekannte Files */
Pixmap		File_Link_PM;	/* Fuer Links */
Pixmap		File_Lock_PM;	/* Fuer nicht lesbare Files */
Pixmap		File_Exec_PM;	/* Fuer ausfuehrbare Programme */
Pixmap		Shape_Exec_PM;	/* Fuer ausfuehrbare Programme */
Pixmap		File_DLink_PM;	/* Fuer comprimierte Dateien */

Pixmap		Dir_Opened_PM;	/* Fuer offene Directories */
Pixmap		Dir_Closed_PM;	/* Fuer geschlossene Directories */
Pixmap		Dir_Locked_PM;	/* Fuer nicht lesbare Directories */

Pixmap		Icon_Move_PM;	/* Icon der Verschiebeoperation */
Pixmap		Icon_Copy_PM;	/* Icon fuer Kopierfunktion */
Pixmap		Icon_Delete_PM;	/* Icon fuer Loeschfunktion */
Pixmap		Icon_Warning_PM;/* Icon fuer die Hinweisbox */
Pixmap		Icon_Newdir_PM;	/* Icon fuer das NewdirCommand */
Pixmap		Icon_Info_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_Hide_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_Help_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_Exec_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_Filter_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_WSE_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_WSD_PM;	/* Icon fuer das Info-Window */
Pixmap		Icon_Link_PM;	/* Icon fuer das Info-Window */

extern	Dimension	typelength;


/*
 * Function Prototypes
 */
/* main.c */
void			setRootDir     (void);
int 			main           (int argc, char **argv);
void			createWidgets  (Widget parent);
void			FATAL_ERROR    (char *message);
void			DEBUG 	       (char *message);
Dir_Glyph		*getGlyph      (Dir_Glyph *d, Dimension x, Dimension y);
MYSIGTYPE		signal_handler (int sig);

XtActionProc		refresh_dirs   (Widget w, XExposeEvent *e, 
					String *s, Cardinal *c);
XtActionProc		refresh_files  (Widget w, XExposeEvent *e, 
					String *s, Cardinal *c);
#ifdef	HAS_QUOTA
void			showQuota      (Widget w);
#endif

/* action.c */
extern	XtActionProc	refresh_dialog_icon(Widget w, XEvent *e,
					String *s, Cardinal *c);
extern	void		init_quit      ();

/* grab.c */
extern	XtActionProc	leaveWindow    (Widget w, XLeaveWindowEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	enterWindow    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c);


/* single.c */
extern	XtActionProc	startSingle    (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	followSingle   (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	endSingle      (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	clearSingle    (Widget w, XEvent *e,
					String *s, Cardinal *c);
XtActionProc		refresh_icon   (Widget w, XExposeEvent *e, 
					String *s, Cardinal *c);

/* multi.c */
extern	XtActionProc	startMulti     (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	followMulti    (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	endMulti       (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	clearMulti     (Widget w, XEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	refreshMulti   (Widget w, XEvent *e,
					String *s, Cardinal *c);

/* dir.c */
extern	void		fillDir        (Dir_Glyph *dir);
extern	void		showDir        (Widget window, Dir_Glyph *dir,
					Dimension x, Dimension y,
					Dimension *lx, Dimension *ly,
					Dimension hs, Dimension he);
extern	String		getPath        (Dir_Glyph *dir);

/* file.c */
extern	void		showFolder     (Widget window, Folder_Glyph *folder,
					Dimension x, Dimension y,
					Dimension *lx, Dimension *ly,
					Dimension hs, Dimension he);
extern	void		fillFolder     (Folder_Glyph *folder);

/* folder.c */
extern	void		newFolder      (Dir_Glyph *dir);
extern	void		makeFolderWindow  (Widget parent, Folder_Glyph *folder, Dimension id);

/* graph.c */
extern	void		makeCursor     (void);
extern	void		loadIcons      (void);

/* menu.c */
extern	void		makeMenu       (Widget bar);
extern	int		getFlags       (struct stat *buf);

/* devices.c */
extern	Widget		CreateDeviceBox(Widget bar, Widget ref);
extern  XtActionProc	RefreshDevices (Widget w, XExposeEvent *e, String *s, Cardinal *c);
extern	void		LoadDeviceIcons(Widget toplevel);

/* customize.c */
extern	Boolean		readCustomSettings(void);
extern	void		loadTypeIcons(void);

/* iconbar.c */
extern	XtActionProc	leaveButton    (Widget w, XLeaveWindowEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	enterButton    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	refreshButton  (Widget w, XEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	endButton      (Widget w, XEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	startButton    (Widget w, XEvent *e, 
					String *s, Cardinal *c);

extern	void		start_exec     (void);
extern	void		start_edit     (void);
extern	void		start_info     (void);
extern	void		start_copy     (void);
extern	void		start_move     (void);
extern	void		start_delete   (void);

/* popup.c */
extern	XtActionProc	startPopup     (Widget w, XButtonEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	hidePopup      (Widget w, XEvent *e,
					String *s, Cardinal *c);
extern	XtActionProc	startCustom    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c);
extern	XtActionProc	startSento     (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c);

/*
 * Den Actionsrec erzeugen
 */
static XtActionsRec actions[] =
{
	{"start-custom",
		(XtActionProc) startSento
	},
	{"start-popup",
		(XtActionProc) startPopup
	},
	{"hide-popup",
		(XtActionProc) hidePopup
	},
	{"refresh-dirs",
		(XtActionProc) refresh_dirs
	},
	{"refresh-devices",
		(XtActionProc) RefreshDevices
	},
	{"refresh-files",
		(XtActionProc) refresh_files
	},
	{"refresh-dialog-icon",
		(XtActionProc) refresh_dialog_icon
	},
	{"refresh-icon",
		(XtActionProc) refresh_icon
	},
	{"clear-single",
		(XtActionProc) clearSingle
	},
	{"start-single",
		(XtActionProc) startSingle
	},
	{"follow-single",
		(XtActionProc) followSingle
	},
	{"end-single",
		(XtActionProc) endSingle
	},
	{"clear-multi",
		(XtActionProc) clearMulti
	},
	{"start-multi",
		(XtActionProc) startMulti
	},
	{"follow-multi",
		(XtActionProc) followMulti
	},
	{"end-multi",
		(XtActionProc) endMulti
	},
	{"refresh-multi",
		(XtActionProc) refreshMulti
	},
	{"leave-window",
		(XtActionProc) leaveWindow
	},
	{"enter-window",
		(XtActionProc) enterWindow
	},
	{"leave-button",
		(XtActionProc) leaveButton
	},
	{"enter-button",
		(XtActionProc) enterButton
	},
	{"refresh-button",
		(XtActionProc) refreshButton
	},
	{"end-button",
		(XtActionProc) endButton
	},
	{"start-button",
		(XtActionProc) startButton
	},
	{"start-edit",
		(XtActionProc) start_edit
	},
	{"start-copy",
		(XtActionProc) start_copy
	},
	{"start-move",
		(XtActionProc) start_move
	},
	{"start-delete",
		(XtActionProc) start_delete
	},
	{"start-exec",
		(XtActionProc) start_exec
	},
	{"start-info",
		(XtActionProc) start_info
	},
};

char* rtdir = "/";

void setRootDir (void)
{
	/*
	 * Den Root-Glyph initialisieren
	 */
	root.x = 0;
	root.y = 0;
	root.open = TRUE;

//#define SHOWROOT
#ifdef SHOWROOT
	if (!strcmp(rtdir,".")){
		rtdir = (String) getenv("PWD");
	}
	root.name = "/";
#else
	if (!strcmp(rtdir,".")) {
		root.name = (String) getenv("PWD");
		if (!root.name)
			root.name = rtdir;
	}
	else
		root.name = rtdir;
#endif
	root.parent = NULL;
	root.dir = NULL;
	root.dir_count = 0;

	/*
	 * Den Status des Root-Directories holen
	 */
	{
		struct stat buf;

		(void) stat (root.name,&buf);
		root.flags = getFlags(&buf);
	}

	fillDir(&root);
	if (folders[0]) fillFolder(folders[0]);
}

/*
**	Function name : main
**
**	Description :	Hauptinitialisierung
**	Input : 	int argc, char **argv;
**	Ouput :		none
*/
int main (int argc, char **argv)
{
	Arg	args[4];
	
	/* disconnect from the console */
	switch (fork()) { case 0: case -1: break; default: exit(0); }

	/*
	 * Den App-Context initalisieren und das ToplevelWidget holen
	 */
	XtSetArg(args[0],XtNminWidth, -12);
	XtSetArg(args[1],XtNminHeight,-31);
	toplevel = XtAppInitialize(&app_context,"Xfilemanager",
				   options,XtNumber(options),
				   &argc,argv,NULL,args,2);

	if(argc == 2) rtdir = argv[1];

	XtAppAddActions (app_context, actions, XtNumber (actions));
	XtVaGetApplicationResources (toplevel,&defaults,resources,
				     XtNumber(resources),NULL);

	/*
	 * Den Main-WidgetTree auf diesem Fenster erzeugen
	 */
	if (!defaults.multi_window) {
		if (!(folder = (Folder_Glyph *) malloc (sizeof(Folder_Glyph))))
			FATAL_ERROR ("main: Cannot create folder\n");

		/*
		 * Den Main-Folder setzen
		 */
		folder->file_count = 0;
		folder->dir = &root;
		folder_count = 1;
		folder->file = NULL;
		folder->filter = NULL;
		folders[0] = folder;
	}
	createWidgets(toplevel);

	/*
	 * Die Usersettings fuer Filetypen einlesen und die Pixmaps
	 * generieren
	 */
	readCustomSettings();

	setRootDir();

	/*
	 * Jetzt die Widgets erst einmal darstellen
	 */
	if (!defaults.multi_window) {
		Arg	args[2];

		XtSetArg(args[0],XtNwidth,90);
		XtSetArg(args[1],XtNheight,90);
		XtSetValues(folder->window,args,2);
	}
	XtRealizeWidget(toplevel);

	/*
	 * Die Pixmaps laden
	 */
	if (getuid() == 0)
		LoadDeviceIcons(toplevel);
	loadIcons();
	loadTypeIcons();
	/*
	 * Die GC's zum Zeichnen des Dir-Trees initialisieren
	 */
	{
		XtGCMask	mask;
		XGCValues	values;
		Arg		args[1];

		mask = GCFont | GCForeground;
		values.font = defaults.icon_font->fid;
		values.foreground = XBlackPixel (XtDisplay(toplevel),
						 XDefaultScreen(XtDisplay(toplevel)));
		line_gc = XtGetGC (toplevel, mask, &values);

		XtSetArg(args[0],XtNbackground,&values.foreground);
		XtGetValues(toplevel,args,1);
		back_gc = XtGetGC (toplevel, mask, &values);

		values.foreground = XWhitePixel (XtDisplay(toplevel),
						 XDefaultScreen(XtDisplay(toplevel)));
		white_gc = XtGetGC (toplevel, mask, &values);

		values.foreground = defaults.select_color;
		selc_gc = XtGetGC (toplevel, mask, &values);
	}
	XtManageChild(dir_area);

	if (!defaults.multi_window) {
		Arg	args[2];
		char	*s = getPath(folder->dir);

		XtSetArg(args[0],XtNwidth,100);
		XtSetArg(args[1],XtNheight,100);
		XtSetValues(folder->window,args,2);
		XtManageChild(folder->window);
		XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
		XtSetValues(folder->label,args,1);
	}

	/*
	 * Den Default Cursor setzen
	 */
	makeCursor();

	XDefineCursor(XtDisplay(dir_area),XtWindow(dir_area), def_cursor);
	if (!defaults.multi_window)
		XDefineCursor(XtDisplay(folder->window),
				XtWindow(folder->window), def_cursor);
	folder = NULL;

	/*
	 * Signalhanlder fuer Abbruche
	 */
	signal(SIGTERM,init_quit);
	signal(SIGQUIT,init_quit);
	signal(SIGINT,init_quit);

#ifdef	HAS_QUOTA
	showQuota(quota_label);
#endif

	signal(SIGCHLD, signal_handler);
	/*
	 * Der Main-Loop
	 */
	XtAppMainLoop(app_context);
}


MYSIGTYPE	signal_handler(int sig)
{
	while (waitpid(-1,NULL,WNOHANG) > 0);
	signal(SIGCHLD, signal_handler);
}


/*
**	Function name : createWidgets
**
**	Description :	Diese Funktion erzeugt ein Directoryfenster
**	Input :		Widget	parent;	Zeiger auf das Parentwidget
**	Ouput :		none
*/
void createWidgets (Widget parent)
{
	Arg	args[12];
	Widget	main_pane,
		field_pane,
		dir_pane,
		dummy,
		viewport,
		dev_box;
	
	
	/*
	 * Zunaechst erst einmal den main-pane erzeugen
	 */
	main_pane = XtCreateManagedWidget("main_pane", panedWidgetClass,
					  parent, args,0);

	/*
	 * Das Haupmenu erzeugen
	 */
	makeMenu (main_pane);

	/*
	 * Die Seperator-pane fuer die Directoryfields setzen
	 */
	if (!defaults.multi_window) {
		XtSetArg(args[0],XtNorientation, XtorientHorizontal);
		field_pane = XtCreateManagedWidget("field_pane", panedWidgetClass,
						   main_pane, args,1);
		XtSetArg(args[0],XtNwidth,250);	/* Bei Single Window hat die
						   Iconbar Oben genug Platz */
	}
	else {
		field_pane = main_pane;
		XtSetArg(args[0],XtNwidth, 250);
	}

	/*
	 * Unter der Dir-Area muss noch ein Feld fuer die Quotas stehen, darum
	 * pane erzeugen
	 */
	dir_pane = XtVaCreateManagedWidget ("dir_pane",formWidgetClass,
						field_pane,
						XtNdefaultDistance, 0,
						NULL);

	/*
	 * Auf dieses field_pane jetzt den Viewport setzen, der das
	 * Simple-Widget fuer den Directory-Tree enthalten soll
	 */
	
	XtSetArg(args[1],XtNheight,92);
	XtSetArg(args[2],XtNallowHoriz, TRUE);
	XtSetArg(args[3],XtNallowVert, TRUE);
	XtSetArg(args[4],XtNforceBars, TRUE);
	XtSetArg(args[5],XtNuseBottom, TRUE);
	XtSetArg(args[6],XtNuseRight, TRUE);
	XtSetArg(args[7],XtNleft, XawChainLeft);
	XtSetArg(args[8],XtNright, XawChainRight);
	XtSetArg(args[9],XtNbottom, XawChainBottom);
	XtSetArg(args[10],XtNtop,XawChainTop);
	viewport = XtCreateManagedWidget("viewport", viewportWidgetClass,
					 dir_pane, args,11);
	dir_vp = viewport;

	/*
	 * Auf das Viewport kommt jetzt das Simple-Widget fuer den
	 * Directory Tree
	 */
	dir_area = XtCreateWidget("dir_simple", simpleWidgetClass,
				  viewport, args, 2);
	XtOverrideTranslations(dir_area, 
			       XtParseTranslationTable("<Leave>: leave-window()\n\
							<Enter>: enter-window()\n\
							<Expose>: refresh-dirs()\n\
							<Btn3Down>: start-popup()\n\
							<Btn1Down>: clear-multi() start-single()\n\
							<Btn1Motion>: follow-single()\n\
							<Btn1Up>: end-single()"));
	/*
	 * Den Quota_label erzeugen
	 */
	if (getuid() == 0)
		dev_box = CreateDeviceBox(dir_pane,viewport);
#ifdef	HAS_QUOTA
	else
		quota_label = XtVaCreateManagedWidget("quota_label",labelWidgetClass,
						dir_pane,
						XtNfromVert,dir_vp,
						XtNborderWidth,0,
						XtNleft, XawChainLeft,
						XtNright, XawChainRight,
						XtNtop, XawChainBottom,
						XtNbottom, XawChainBottom,
						XtNjustify, XtJustifyLeft,
						XtNwidth, (300),
						NULL);
#endif
	/*
	 * Den ersten Folder ersellen, je nach Status der Default-Variable
	 * im Pane in einem eigenen Fenster
	 */
	if (!defaults.multi_window) {
		dummy = field_pane;
		/*
		 * Den Folder erzeugen
		 */
		makeFolderWindow (dummy, folder,0);
	}
	else {
		Widget	shell;

		shell = XtCreatePopupShell("ws_shell",topLevelShellWidgetClass,
					   toplevel, NULL,0);
	}
}



/*
**	Function name : FATAL_ERROR
**
**	Description : Bricht im Fehlerfall mit einer Fehlermeldung ab
**	Input : 
**	Ouput :
*/
void FATAL_ERROR (char *message)
{
	fprintf(stderr,"%s",message);
	exit(1);
}



/*
**	Function name : refresh_files
**
**	Description : Neuzeichnen des Directories nach einem Expose
**	Input : none
**	Ouput : none
*/
XtActionProc refresh_files (Widget w, XExposeEvent *e, String *s, Cardinal *c)
{
	Dimension	lx = 0, ly;
	Arg		args[4];
	int		hs, he;
	Folder_Glyph	*rfolder;

	while (lx < folder_count && lx < MAX_FOLDERS && folders[lx]->window != w)
		lx++;

	if (lx < folder_count) {
		rfolder = folders[lx];

		/*
		 * Directorypfad neu Zeichnen
		 */
		if (FILE_CHANGED) {
			XClearWindow(XtDisplay(rfolder->window),
				     XtWindow(rfolder->window));
			FILE_CHANGED = FALSE;
			if (!defaults.multi_window)
				XtMoveWidget(rfolder->window,0,0);
		}
		/*
		 * Berechnen, welche Eintrage gerade sichtbar sind und eines Refreshs
		 * beduerfen. Die derzeitige Loesung koennte Probleme bei Terminals
		 * mit Backingstores geben.
		 */
		if (!e){
			hs = 0;
			he = rfolder->file_count - 1;
		}
		else {
			hs = (e->y - 4) / DIR_Y_STEP;
			if (hs < 0)
				hs = 0;
			he = hs + e->height/DIR_Y_STEP + 1;
			if (he > rfolder->file_count - 1)
				he = rfolder->file_count - 1;
		}
		showFolder (rfolder->window, rfolder, 20, 6, &lx, &ly, hs, he);

		/*
		 * Die Hoehe anpassen
		 */
		{
			Arg		args[2];

			XtSetArg(args[0],XtNwidth,lx + 4*DIR_Y_STEP + typelength);
			XtSetArg(args[1],XtNheight, ly + 2*DIR_Y_STEP);
			XtSetValues(rfolder->window,args,2);
		}
	}
}



/*
**	Function name : refresh_dirs
**
**	Description : Neuzeichnen des Directories nach einem Expose
**      New drawings of the Directories after an Expose
**	Input : none
**	Ouput : none
*/
XtActionProc refresh_dirs (Widget w, XExposeEvent *e, String *s, Cardinal *c)
{
	Dimension	lx = 0, ly = 0;
	int		hs,he;

	/*
	 * Directorypfad neu Zeichnen
	 */
	if (DIR_CHANGED) {
		DIR_CHANGED = FALSE;
		XClearWindow(XtDisplay(dir_area),XtWindow(dir_area));
	}
	/*
	 * Berechnen, welche Eintrage gerade sichtbar sind und eines Refreshs
	 * beduerfen. Die derzeitige Loesung koennte Probleme bei Terminals
	 * mit Backingstores geben.
	 *
	 * Calculate which entries are just visible and Refresh accordingly.
	 * The present solution could give problems in Terminals with 
	 * Backingstore enabled.
	 */
	if (!e) {
		hs = 0;
		he = 16000;
	}
	else {
		hs = e->y - DIR_Y_STEP;
		if (hs < 0)
			hs = 0;

		he = hs + e->height + 2*DIR_Y_STEP;
	}

	showDir (dir_area, &root, 20, 6, &lx, &ly,hs,he);

	/*
	 * Die Hoehe anpassen
	 */
	{
		Arg		args[2];

		XtSetArg(args[0],XtNwidth,lx + 5*DIR_Y_STEP);
		XtSetArg(args[1],XtNheight, ly + 2*DIR_Y_STEP);
		XtSetValues(dir_area,args,2);
	}
}

/*
**	Function name : getGlyph
**
**	Description : Prueft, ob an den Koordinaten x,y ein Glyph liegt
**	Input : Dir_Glyph Root; Position x,y
**	Ouput :
*/
Dir_Glyph *getGlyph (Dir_Glyph *d, Dimension x, Dimension y)
{
	/*
	 * Pruefen ob Punkt ueberhaupt im Bereich liegen kann
	 */
	if (y < d->y || x < d->x)
		return(NULL);

	/*
	 * Pruefen ob das Icon das an dieser Position liegt
	 */
	if ( y < d->y + 16 && x < d->x + 24 + 8*strlen(d->name))
		return(d);

	/*
	 * Das Stammglyph war es nicht, also Verzeichnis durchsuchen
	 */
	if (d->dir_count > 0 && d->open) {
		int	i;

		/*
		 * alle Glyphs durchprobieren
		 */
		for (i = 0; i < d->dir_count; i++) {
			Dir_Glyph	*b;

			b = getGlyph(d->dir[i],x,y);
			if (b != NULL)
				return(b);
		}
	}
	return(NULL);
}


/*
**	Function name : DEBUG
**
**	Description : Gibt eine Debugmessage aus
**	Input : char *message - Nachricht die ausgegeben werden soll
**	Ouput :
*/
void DEBUG (char *message)
{
	printf("DEBUG: %s\n",message);
}


#ifdef	HAS_QUOTA
/*********************************************************
 * name:	showQuota
 * description:	Anzeigen der Userquotas
 * input:	Widget w - Quota-Label
 * output:	none
 * author:	Ove Kalkan
 * date:	20.7.1993
 *********************************************************/
void	showQuota(Widget w)
{
	uid_t	uid = getuid();
	Arg	args[1];
#if defined(hpux) || defined(ultrix)
	struct dqblk	addr;
#endif
	if (uid == 0)
		return;
#if defined(hpux) || defined(ultrix)
	if (quotactl(Q_GETQUOTA,QUOTA_DEV,
			uid, (void *) &addr))
#else
	if (1)
#endif		
		XtSetArg(args[0],XtNlabel,"Cannot get Quotas");
	else {
		char	s[200];
#if defined(hpux) || defined(ultrix)
		sprintf(s,"Quotas: %d of %d Blocks",
			addr.dqb_curblocks,
				addr.dqb_bsoftlimit);
#endif
		XtSetArg(args[0],XtNlabel,s);
	}
	XtSetValues(w,args,1);
}

#endif


