/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/X.h>
#include <X11/cursorfont.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#ifdef XAW
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Label.h>
#endif /* XAW */
#ifdef XAWPLUS
#include <X11/XawPlus/Paned.h>
#include <X11/XawPlus/Form.h>
#include <X11/XawPlus/Viewport.h>
#include <X11/XawPlus/Simple.h>
#include <X11/XawPlus/Label.h>
#endif /* XAWPLUS */

#include "struct.h"
#include "config.h"



/*
 * Globale Variablen
 */

extern	Folder_Glyph	*folder;
extern	Folder_Glyph	*folders[];
extern	Dimension	folder_count;

extern	Widget		dir_area;
extern	Widget		toplevel;
extern	Widget		dir_vp;

extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;

extern	Dir_Glyph	*last_g;
extern	Dimension	last_y;
extern	Dimension	last_v;
extern	Folder_Glyph	*last_fo;

extern	Boolean		GRAB;
extern	Boolean		REFRESH;

extern	Cursor		file_cursor;
extern	Cursor		def_cursor;

extern	GC		back_gc;
extern	Dimension	typelength;

extern	xfm_struct	defaults;
extern	WS_Glyph	workspace;

/*
 * Function Prototypes
 */
XtActionProc		leaveWindow    (Widget w, XLeaveWindowEvent *e, 
					String *s, Cardinal *c);
XtActionProc		enterWindow    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c);

Widget			grabWindow     (XButtonEvent *e);
Boolean			isInWindow     (Widget s, Widget c, Widget a, 
					short *x, short *y);
Boolean			isHigher       (Widget a, Widget b);

extern	void		DEBUG	       (char *mesg);

/*********************************************************
 * name:	leaveWindow
 * description:	Wird immer dann aufgerufen, wenn ein Fenster
 *		verlassen wurde.Es werden die fuer die Grab
 *		Funktion wichtigen Parameter gesetzt
 * description:	Called whenever leaving a window. Sets important Grab parameter.
 * input:	Widget	w	- Fenster das verlassen wurde
 *		XEvent	*e	- der Event
 *		String	*s	- notused
 *		Cardinal *c	- notused
 * output:	none
 * author:	Ove Kalkan
 * date:	16.6.93
 *********************************************************/
XtActionProc		leaveWindow    (Widget w, XLeaveWindowEvent *e, 
					String *s, Cardinal *c)
{
	/*
	 * Wenn es eine Grab-Operation gibt, dann das Highlight loeschen
	 * If there is a grave operation, then the highlight delete.
	 */
	if (GRAB) {
		if (last_g) {
			XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
				       back_gc, last_g->x - 4, last_g->y - 2,
				       32 + XTextWidth (defaults.icon_font,
					last_g->name,strlen(last_g->name)), 20);
			last_y = 16000;
			last_g = NULL;
		}
		else if (folder && last_v < 16000) {
			XDrawRectangle(XtDisplay(folder->window),XtWindow(folder->window),
				       back_gc, 16, last_v*DIR_Y_STEP + 4,
				       folder->max_length + 50 + typelength, 20);
			last_v = 16000;
		}
	}
	folder = NULL;	/* Zeiger auf derzeitiges Window, wird nur innerhalb
			   von Fenstern gebraucht */
	/*
	 * Muss gemacht werden, da nach einem XGrabButton ein LeaveNotify kommt
	 * und bei einem Grab in einem FolderFenster der Folder sonst verloren
	 * gehen wuerde und man erst aus dem Fenster hinaus und danach wieder
	 * hinein fahren muesste, damit das Fenster reagiert.

	 * Must be made, since to a XGrabButton a LeaveNotify comes and would be
	 * lost with a grave in a folder window of the folders otherwise and one
	 * would have to only drive from the window outside and to it again
	 * inside, so that the window reacts.
	 */
	if (REFRESH) {
		last_fo = selc_fo;
		folder = selc_fo;
		last_v = selc_f;
		REFRESH = FALSE;
	}
}


/*********************************************************
 * name:	enterWindow
 * description:	Wird immer dann aufgerufen, wenn der Mauszeiger
 *		in ein Fenster faehrt.
 * description:	Called whenever the mouse pointer moves into a window.
 * input:	Widget	w	- Fenster das verlassen wurde
 *		XEvent	*e	- der Event
 *		String	*s	- notused
 *		Cardinal *c	- notused
 * output:	none
 * author:	Ove Kalkan
 * date:	16.6.93
 *********************************************************/
XtActionProc		enterWindow    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c)
{
	if (w != dir_area) {
		Dimension	i = 0;

		while (i < folder_count && i < MAX_FOLDERS && folders[i]->window != w)
			i++;

		if (i < folder_count) {
			folder = folders[i];
		}
	}
}



