#ifndef SYSINFO_H
#define SYSINFO_H

int        loadavg(double *av1, double *av5, double *av15);
int        uptime (double *uptime_secs, double *idle_secs);
unsigned** meminfo(void);
unsigned** procstat(void);

enum meminfo_row { meminfo_main = 0,
		   meminfo_swap };

enum meminfo_col { meminfo_total = 0, meminfo_used, meminfo_free,
		   meminfo_shared, meminfo_buffers, meminfo_cached };

enum procstat_row { procstat_cpu = 0, procstat_disk, procstat_disk_rio,
		    procstat_disk_wio, procstat_disk_rblk, procstat_disk_wblk,
		    procstat_page, procstat_swap, procstat_intr,
		    procstat_ctxt, procstat_btime };

enum procstat_cpu_col { procstat_cpu_user = 0, procstat_cpu_nice, 
			procstat_cpu_system, procstat_cpu_idle };

enum procstat_page_col { procstat_page_in = 0, procstat_page_out };

enum procstat_swap_col { procstat_swap_in = 0, procstat_swap_out };

unsigned read_total_main(void);

#endif /* SYSINFO_H */
