/* 	$Id: SmeToggle.h,v 1.3 1998/02/05 20:46:22 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/*
Copyright (c) 1989, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
*/

#ifndef _SmeToggle_h
#define _SmeToggle_h

/***********************************************************************
 *
 * SmeToggle Object
 *
 ***********************************************************************/

#ifdef XAW3D
#include <X11/Xaw3d/SmeBSB.h>
#else
#include <X11/XawPlus/SmeBSB.h>
#endif

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 radioGroup          RadioGroup         Widget          NULL               i
 radioData           RadioData          Pointer         (XPointer) Widget  ii
 state               State              Boolean         Off
 placement	     Placement		XtJustify	XtJustifyLeft      iii
 onBitmap            OnBitmap           Pixmap          None
 offBitmap           OffBitmap          Pixmap          None
 callback            Callback           Callback        NULL
 destroyCallback     Callback		Pointer		NULL
 font                Font               XFontStruct *   XtDefaultFont
 foreground          Foreground         Pixel           XtDefaultForeground
 height		     Height		Dimension	0
 label               Label              String          Name of entry
 leftMargin          HorizontalMargins  Dimension       4
 rightMargin         HorizontalMargins  Dimension       4
 sensitive	     Sensitive		Boolean		True
 vertSpace           VertSpace          int             25
 width		     Width		Dimension	0
 x		     Position		Position	0n
 y		     Position		Position	0


i To use the toggle as a radio toggle button, set this resource to point to
  any other widget in the radio group.

ii This is the data returned from a call to XtToggleGetCurrent, by default
   this is set to the name of toggle widget.

iii Only XtJustifyLeft and XtJustifyRight are supported

*/


#define XtCOnBitmap "OnBitmap"
#define XtCOffBitmap "OffBitmap"
#define XtCWidget "Widget"
#define XtCState "State"
#define XtCRadioGroup "RadioGroup"
#define XtCRadioData "RadioData"
#define XtCPlacement "Placement"

#ifndef _XtStringDefs_h_
#define XtRWidget "Widget"
#endif

#define XtNonBitmap "onBitmap"
#define XtNoffBitmap "offBitmap"
#define XtNstate "state"
#define XtNradioGroup "radioGroup"
#define XtNradioData "radioData"
#define XtNplacement "placement"

#define XstoTURNON 1
#define XstoTURNOFF 0
#define XstoRADIO_TURNOFF -1 
/* call data when state change is due to radio sibling */

extern WidgetClass smeToggleObjectClass;

typedef struct _SmeToggleClassRec *SmeToggleObjectClass;
typedef struct _SmeToggleRec *SmeToggleObject;


/************************************************************
 * 
 * Public Functions
 *
 ************************************************************/

_XFUNCPROTOBEGIN
   
/*	Function Name: XstoChangeRadioGroup
 *	Description: Allows a toggle widget to change radio groups.
 *	Arguments: w - The toggle widget to change groups.
 *                 group_w - any widget in the new group.
 *	Returns: none.
 */

extern void XstoChangeRadioGroup(
#if NeedFunctionPrototypes
    Widget		/* w */,
    Widget		/* group_w */
#endif
);

/*	Function Name: XstoGetCurrent
 *	Description: Returns the RadioData associated with the toggle
 *                   widget that is currently active in a toggle group.
 *	Arguments: group_w - any toggle widget in the toggle group.
 *	Returns: The XtNradioData associated with the toggle widget.
 */

extern XtPointer XstoGetCurrent(
#if NeedFunctionPrototypes
    Widget		/* group_w */
#endif
);

/*	Function Name: XstoSetCurrent
 *	Description: Sets the Toggle widget associated with the
 *                   radio_data specified.
 *	Arguments: group_w - any toggle widget in the toggle group.
 *                 radio_data - radio data of the toggle widget to set.
 *	Returns: none.
 */

extern void XstoSetCurrent(
#if NeedFunctionPrototypes
    Widget		/* group_w */,
    XtPointer		/* radio_data */
#endif
);

/*	Function Name: XstoUnsetCurrent
 *	Description: Unsets all Toggles in the specified radio group.
 *	Arguments: group_w - any toggle widget in the radio group.
 *	Returns: none.
 */

extern void XstoUnsetCurrent(
#if NeedFunctionPrototypes
    Widget		/* group_w */
#endif
);

_XFUNCPROTOEND

#endif /* _SmeToggle_h */







