/* 	$Id: SmeCascade.h,v 1.3 1998/02/05 21:29:44 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/*
Copyright (c) 1989, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
*/

#ifndef _SmeCascade_h
#define _SmeCascade_h

/***********************************************************************
 *
 * SmeCascade Object
 *
 ***********************************************************************/

#ifdef XAW3D
#include <X11/Xaw3d/SmeBSB.h>
#else
#include <X11/XawPlus/SmeBSB.h>
#endif

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 cascadeBitmap       CascadeBitmap      Pixmap          None
 submenuShell        submenuShell       Widget          NULL
 destroyCallback     Callback		Pointer		NULL
 font                Font               XFontStruct *   XtDefaultFont
 foreground          Foreground         Pixel           XtDefaultForeground
 height		     Height		Dimension	0
 label               Label              String          Name of entry
 leftMargin          HorizontalMargins  Dimension       4
 rightMargin         HorizontalMargins  Dimension       4
 sensitive	     Sensitive		Boolean		True
 vertSpace           VertSpace          int             25
 width		     Width		Dimension	0
 x		     Position		Position	0n
 y		     Position		Position	0

*/

/*
 * These should be in StringDefs.h but aren't so we will define
 * them here if they are needed.
 */

#define XtCCascadeBitmap "CascadeBitmap"
#define XtCSubmenuShell "SubmenuShell"

#ifndef _XtStringDefs_h_
#define XtRWidget "Widget"
#endif

#define XtNcascadeBitmap "cascadeBitmap"
#define XtNsubmenuShell "submenuShell"

extern WidgetClass smeCascadeObjectClass;

typedef struct _SmeCascadeClassRec *SmeCascadeObjectClass;
typedef struct _SmeCascadeRec *SmeCascadeObject;


/************************************************************
 * 
 * Public Functions
 *
 ************************************************************/

_XFUNCPROTOBEGIN
   
_XFUNCPROTOEND

#endif /* _SmeCascade_h */







