/* 	$Id: SmeCascade.c,v 1.3 1998/02/05 21:26:32 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/*
Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
*/

#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>


#ifdef XAW3D
#include <X11/Xaw3d/XawInit.h>
#include <X11/Xaw3d/SimpleMenP.h>
#include <X11/Xaw3d/Cardinals.h>
#include <X11/Xaw3d/SmeBSB.h>
#else
#include <X11/XawPlus/XawInit.h>
#include <X11/XawPlus/SimpleMenP.h>
#include <X11/XawPlus/Cardinals.h>
#include <X11/XawPlus/SmeBSB.h>
#endif
#include "SmeCascadP.h"

static XtResource resources[] = {
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {XtNcascadeBitmap, XtCCascadeBitmap, XtRBitmap, sizeof(Pixmap),
   XtOffsetOf(SmeCascadeRec, sme_bsb.right_bitmap), 
   XtRImmediate, (XtPointer) None},
  {XtNsubmenuShell, XtCSubmenuShell, XtRWidget, sizeof(Widget), 
   XtOffsetOf(SmeCascadeRec, sme_cascade.submenu_shell), 
   XtRWidget, (XtPointer) NULL}
};

static void ClassInitialize(void);
/* register additional resource converter */

static void Initialize(Widget, Widget, ArgList, Cardinal *);
/* register callback on parents XtNpopdownCallback list */

static void Destroy(Widget);
/* free resources associated with the widget */

static void Highlight(Widget);
/* highlight entry and pop up associated submenu */

static void Unhighlight(Widget);
/* unhighlight entry and pop down associated submenu */

SmeCascadeClassRec smeCascadeClassRec = {
  { 
    /* RectObjClass fields */
    /* superclass		*/	(WidgetClass) &smeBSBClassRec,
    /* class_name		*/	"SmeCascade",
    /* widget_size		*/	sizeof(SmeCascadeRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	False,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	NULL,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	False,
    /* compress_exposure	*/	False,
    /* compress_enterleave	*/	False,
    /* visible_interest		*/	False,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/      NULL,
    /* extension		*/	NULL
  },
  {
    /* SmeClass fields */
    /* highlight          */	        Highlight,
    /* unhighlight        */	        Unhighlight,
    /* notify             */	        XtInheritNotify,		
    /* extension	  */	        NULL
  },
#ifdef XAW3D
  {
    /* ThreeDClass Fields */
    /* shadowdraw         */            XtInheritXawSme3dShadowDraw
  },
#endif
  {
    /* BSBClass Fields */
    /* extension */                     NULL
  },
  { /* SmeCascadeClass fields */
    /* empty			*/	0
  }
};

WidgetClass smeCascadeObjectClass = (WidgetClass) &smeCascadeClassRec;

static Boolean IsMapped(Widget w);
/* return True if widget's window is mapped */

static void clear_active_entry(Widget);
/* clear active entry in submenu */

static void position_submenu(SmeCascadeObject);
/* position submenu to the right of SmeCascade entry */

static void popdown_submenu(Widget, XtPointer, XtPointer);
/* pop down submenu and unset its active entry */

static void ClassInitialize(void)
/* register additional resource converter */
{
  static XtConvertArgRec parentCvtArgs[] = { 
    {XtBaseOffset, (XtPointer) XtOffsetOf(ObjectRec, object.parent), 
     sizeof(Widget)} 
  }; 

  XawInitializeWidgetSet();
  /* 
   * register converter for mapping widget name to id allowing
   * to specify the popup shell in the resource files
   */
  XtSetTypeConverter(XtRString, XtRWidget, XmuNewCvtStringToWidget,
		     parentCvtArgs, XtNumber(parentCvtArgs), XtCacheNone,
		     (XtDestructor) NULL);
}

static void Initialize(Widget request, Widget new, ArgList args, 
		       Cardinal *num_args)
/* register callback on parents XtNpopdownCallback list */
{
  /*
   * the callback registered on parents XtNpopdownCallback list pops down 
   * the submenu triggering in turn the callbacks on its XtNpopdownCallback 
   * list; eventually all cascading submenus are popped down
   */
  XtAddCallback(XtParent(new), XtNpopdownCallback, popdown_submenu, 
		(XtPointer) new); 
}

static void Destroy(Widget w)
/* free resources associated with the widget */
{
  XtRemoveCallback(XtParent(w), XtNpopdownCallback, popdown_submenu, 
		   (XtPointer) w); 
}

static void Highlight(Widget w)
/* highlight entry and pop up associated submenu */
{
  /*
   * ignore invocations due to Enter/LeaveNotify events triggered by
   * popping down of parent
   */
  if(IsMapped(XtParent(w)))
    {
      SmeCascadeObject sco = (SmeCascadeObject) w;
      SmeCascadeObjectClass class = 
	(SmeCascadeObjectClass) (sco->object.widget_class);
      SmeBSBObjectClass superclass = 
	(SmeBSBObjectClass) (class->rect_class.superclass);

      /* call superclasses method to highlight entry */
      (superclass->sme_class.highlight)(w);
      /* check if resource is set */
      if(!sco->sme_cascade.submenu_shell)
	{
	  XtAppWarning(XtWidgetToApplicationContext(w),
		       "No submenu pop-up specified for SmeCascade entry"); 
	  return;
	}
      position_submenu(sco);
      XtPopup(sco->sme_cascade.submenu_shell, XtGrabNone);
      /*
       * add the submenu shell to the grab list; use a separate call to 
       * allow invocation of XtPopdown after the root shell of the cascading
       * menu tree popped down and removed the grab; use nonexclusive grab
       * so all events are additionally sent to spring loaded root shell
       */
      XtAddGrab(sco->sme_cascade.submenu_shell, False, False);
    }
}

static void Unhighlight(Widget w)
/* highlight entry and pop up associated submenu */
{
  /*
   * ignore invocations due to Enter/LeaveNotify events triggered by
   * popping down of parent
   */
  if(IsMapped(XtParent(w)))
    {
      SmeCascadeObject sco = (SmeCascadeObject) w;
      SmeCascadeObjectClass class = 
	(SmeCascadeObjectClass) (sco->object.widget_class);
      SmeBSBObjectClass superclass = 
	(SmeBSBObjectClass) (class->rect_class.superclass);
      XEvent *ev;

      /* check if resource is set */
      if(!sco->sme_cascade.submenu_shell)
	{
	  /* call superclasses method to unhighlight entry */
	  (superclass->sme_class.unhighlight)(w);
	  XtAppWarning(XtWidgetToApplicationContext(w),
		       "No submenu pop-up specified for SmeCascade entry"); 
	  return;
	}
      ev = XtLastEventProcessed(XtDisplayOfObject(w));
      if(ev->type == LeaveNotify)
	{
	  SimpleMenuWidget parent = (SimpleMenuWidget) XtParent(w);
	  
	  parent->simple_menu.entry_set = (SmeObject) w;
	  return;
	}
      XtPopdown(sco->sme_cascade.submenu_shell);
      XtRemoveGrab(sco->sme_cascade.submenu_shell);
      clear_active_entry(sco->sme_cascade.submenu_shell);
      /* call superclasses method to unhighlight entry */
      (superclass->sme_class.unhighlight)(w);
    }
}

static Boolean IsMapped(Widget w)
/* return True if widget's window is mapped */
{
  if(XtIsRealized(w))
    {
      XWindowAttributes wa;

      /* ask X about window attributes */
      XGetWindowAttributes(XtDisplay(w), XtWindow(w), &wa);
      return wa.map_state != IsUnmapped;
    }
  return False;
}

static void clear_active_entry(Widget menu_shell)
/* clear active entry in submenu */
{
  SmeBSBObject active_entry = 
    (SmeBSBObject) XawSimpleMenuGetActiveEntry(menu_shell);

  if(active_entry)
    {
#ifdef XAW3D
      /* 
       * state information is stored in the shadowed attribute of 
       * Xaw3d's SmeBSB widget: if set, the widget redraws itself 
       * as if it was the active entry; consequently we have to unset 
       * it here 
       */ 
      active_entry->sme_threeD.shadowed = False;
#endif
      /* clear state information stored in the SimpleMenu widget */
      XawSimpleMenuClearActiveEntry(menu_shell);
    }
}  

static void position_submenu(SmeCascadeObject sco)
/* position submenu to the right of SmeCascade entry */
{
  Widget submenu = sco->sme_cascade.submenu_shell;
  Position submenu_x, submenu_y;
  Dimension submenu_width, submenu_height;
  Dimension entry_width = sco->rectangle.width;
  Arg arglist[2];
  Cardinal n;

  submenu_width = submenu->core.width + 2 * submenu->core.border_width;
  submenu_height = submenu->core.height + 2 * submenu->core.border_width;
  /* get root window coordinates of upper left corner of SmeCascade entry */
  XtTranslateCoords((Widget) sco, 0, 0, &submenu_x, &submenu_y);
  if(submenu_x + entry_width >= 0)
    /* right edge on screen? */
    {
      int scr_width = WidthOfScreen(XtScreen(submenu));
      
      if(submenu_x + entry_width + submenu_width > scr_width)
	/* pop up submenu on the left side instead */
	submenu_x -= submenu_width;
      else
	submenu_x += entry_width;
    }
  else
    submenu_x = 0;
  if (submenu_y >= 0)
    /* top edge on screen? */
    {
      int scr_height = HeightOfScreen(XtScreen(submenu));

      if (submenu_y + submenu_height > scr_height)
	/* align bottom edge of submenu with bottom edge of screen */ 
	submenu_y = scr_height - submenu_height;
    }
  else
    submenu_y = 0;
  n = 0;
  XtSetArg(arglist[n], XtNx, submenu_x); n++;
  XtSetArg(arglist[n], XtNy, submenu_y); n++;
  XtSetValues(submenu, arglist, n);
}

static void popdown_submenu(Widget w, XtPointer client, XtPointer call)
/* pop down submenu and unset its active entry */
{
  SmeCascadeObject sco = (SmeCascadeObject) client;

  /* check if resource is set */
  if(!sco->sme_cascade.submenu_shell)
    {
      XtAppWarning(XtWidgetToApplicationContext((Widget) client),
		   "No submenu pop-up specified for SmeCascade entry"); 
      return;
    }
  XtPopdown(sco->sme_cascade.submenu_shell);
  /* 
   * don't call XtRemoveGrab: grab was already removed by the menu 
   * triggering the pop down sequence 
   */ 
  clear_active_entry(sco->sme_cascade.submenu_shell);
}











