/* 	$Id: Listsel.h,v 1.14 1997/12/07 19:17:21 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */

/***********************************************************

Copyright (c) 1987, 1988, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _Listsel_h
#define _Listsel_h

#include <X11/Intrinsic.h>
#include <X11/Xaw/List.h>

/***********************************************************************
 *
 * Listsel Widget
 *
 ***********************************************************************/

/* new resources 

 Name                Class              RepType         Default Value
 ----                -----              -------         -------------
 headlineLabel       Label              String          headline
 availableLabel      Label              String          available
 selectedLabel       Label              String          selected
 resetLabel          Label              String          reset
 exchangeLabel       Label              String          exchange
 acceptLabel         Label              String          accept
 rejectLabel         Label              String          reject
 configFlags         ConfigFlags        int             15
 choicesList         StringList         String *        NULL
 numberChoices       Number             int             0
 selectedIndex       IntIndex           int *           NULL
 numberSelected      Number             int             0
 spacing             Thickness          int             4
 selectCallback      Callback           XtCallbackList  NULL *1
 deselectCallback    Callback           XtCallbackList  NULL *1
 resetCallback       Callback           XtCallbackList  NULL *1
 exchangeCallback    Callback           XtCallbackList  NULL *1
 acceptSelection     Callback           XtCallbackList  NULL
 rejectSelection     Callback           XtCallbackList  NULL
 comparisonFunction  ComparisonFunction XlswComparisonFunction NULL

 *1 nevertheless there is some default action taken which can be 
    replaced by registering a callback list

 */

/* hierarchy of automatically-created children (sub-objects)

 Name                Class              Parent
 ----                -----              ------
 headlineLabel       Label              -
 availableLabel      Label              -
 selectedLabel       Label              -
 availableViewport   Viewport           -
 availableList       List               availableViewport
 setBox              Box                -
 resetCommand        Command            setBox
 exchangeCommand     Command            setBox
 selectedViewport    Viewport           -
 availableList       List               selectedViewport
 closureBox          Box                -
 acceptCommand       Command            closureBox
 rejectCommand       Command            closureBox
 grip                Grip               -

 */

#define XtNheadlineLabel "headlineLabel"
#define XtNavailableLabel "availableLabel"
#define XtNselectedLabel "selectedLabel"
#define XtNresetLabel "resetLabel"
#define XtNexchangeLabel "exchangeLabel"
#define XtNchoicesList "choicesList"
#define XtNnumberChoices "numberChoices"
#define XtNselectedIndex "selectedIndex"
#define XtNnumberSelected "numberSelected"
#define XtNconfigFlags "configFlags"
#define XtNacceptLabel "acceptLabel"
#define XtNrejectLabel "rejectLabel"
#define XtNspacing "spacing"
#define XtNselectCallback "selectCallback"
#define XtNdeselectCallback "deselectCallback"
#define XtNresetCallback "resetCallback"
#define XtNexchangeCallback "exchangeCallback"
#define XtNacceptCallback "acceptCallback"
#define XtNrejectCallback "rejectCallback"
#define XtNcomparisonFunction "comparisonFunction"

#define XtCStringList "StringList"
#define XtCIntIndex "IntIndex"
#define XtCNumber "Number"
#define XtCConfigFlags "ConfigFlags"
#define XtCComparisonFunction "ComparisonFunction"

#define XlswHEADLINE_LABEL "headlineLabel"
#define XlswAVAILABLE_LABEL "availableLabel"
#define XlswSELECTED_LABEL "selectedLabel"
#define XlswAVAILABLE_VIEWP "availableViewport"
#define XlswSELECTED_VIEWP "selectedViewport"
#define XlswAVAILABLE_LIST "availableList"
#define XlswSELECTED_LIST "selectedList"
#define XlswSET_BOX "setBox"
#define XlswRESET_CMD "resetCommand"
#define XlswEXCHANGE_CMD "exchangeCommand"
#define XlswCLOSURE_BOX "closureBox"
#define XlswACCEPT_CMD "acceptCommand"
#define XlswREJECT_CMD "rejectCommand"
#define XlswGRIP "grip"

#define XlswINVALID_INDEX -1
#define XlswMANAGE_HEADLINE 1
#define XlswMANAGE_SET 2
#define XlswMANAGE_CLOSURE 4
#define XlswMANAGE_GRIP 8

typedef struct _ListselClassRec	*ListselWidgetClass;
typedef struct _ListselRec *ListselWidget;

typedef int (*XlswComparisonFunction)(int *, int *);

extern WidgetClass listselWidgetClass;

_XFUNCPROTOBEGIN

extern void XlswListChange(Widget, String *, int);
/* specify new list of choices to select from */

extern int *XlswGetEligible(Widget);
/* return the still available choices */

extern int *XlswGetSelection(Widget);
/* return selection */

extern void XlswAddToSelection(Widget, int *, int);
/* add choice to selection */

extern void XlswRemoveFromSelection(Widget, int *, int);
/* remove choice from selection */

extern void XlswSetComparisonFunction(Widget, XlswComparisonFunction);
/* set comparison function */

_XFUNCPROTOEND

#endif





