/* 	$Id: CircMeterP.h,v 1.2 1997/06/23 11:27:36 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */


/*
Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
*/


#ifndef _CircMeterP_h
#define _CircMeterP_h

#include "CircMeter.h"
#include <X11/CoreP.h>

#define XcmwGET_TEXT_EXTENT 0x01
#define XcmwSET_WIDTH       0x02
#define XcmwSET_HEIGHT      0x04

typedef struct {
  int empty;
} CircMeterClassPart;

typedef struct _CircMeterClassRec {
  CoreClassPart	core_class;
  CircMeterClassPart circ_meter_class;
} CircMeterClassRec;

extern CircMeterClassRec circMeterClassRec;

typedef struct _CircSector {
  Pixel color;
  int arc;
  String label;
  Position label_x;
  Dimension label_width;
  int label_len;
} CircSector;

typedef struct {
  /* resources */
  Pixel foreground;
  XFontStruct *font;
  String headline;
  XtJustify justify;
  XtJustify placement;
  Dimension spacing;
  int num_sectors;
  CircSector sector[XcmwNUM_SECTORS];
  /* private */
  GC gc;
  Position circ_x;
  Dimension circ_radius;
  Position headline_x;
  Dimension headline_width;
  int headline_len;
  Dimension text_width;
  Dimension text_height;
  Dimension font_height;
} CircMeterPart;

typedef struct _CircMeterRec {
  CorePart core;
  CircMeterPart	circ_meter;
} CircMeterRec;

#endif /* _CircMeterP_h */





