/* 	$Id: CircMeter.h,v 1.3 1997/11/23 16:38:14 pirx Exp $	 */

/*
 * Author: Achim Bangert (abangert@ix.urz.uni-heidelberg.de)
 */


/*
Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
*/

#ifndef _CircMeter_h
#define _CircMeter_h

#include <X11/Xmu/Converters.h>

/****************************************************************
 *
 * CircMeter widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 foreground          Foreground         Pixel           XtDefaultForeground
 font                Font               XFontStruct*    XtDefaultFont
 headline            Headline           String          NULL
 justify             Justify            XtJustify       XtJustifyLeft
 placement           Placement          XtJustify       XtJustifyRight      i
 spacing             Spacing            int             4
 numberSectors       NumberSectors      int             0                   ii
 color1              Color1             Pixel           blue
 arc1                Arc1               int             0
 label1              Label1             String          NULL
 ...
 color4              Color4             Pixel           red
 arc4                Arc4               int             0
 label4              Label4             String          NULL
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

 i:  only XtJustifyLeft or XtJustifyRight are supported
 ii: up to XcmwNUM_SECTORS are possible

*/

typedef struct _CircMeterClassRec *CircMeterWidgetClass;
typedef struct _CircMeterRec *CircMeterWidget;

/* declare the class constant */

extern WidgetClass circMeterWidgetClass;

#define XtNheadline "headline"
#define XtNplacement "placement"
#define XtNspacing "spacing"
#define XtNnumberSectors "numberSectors"
#define XtNcolor1 "color1"
#define XtNarc1 "arc1"
#define XtNlabel1 "label1"
#define XtNcolor2 "color2"
#define XtNarc2 "arc2"
#define XtNlabel2 "label2"
#define XtNcolor3 "color3"
#define XtNarc3 "arc3"
#define XtNlabel3 "label3"
#define XtNcolor4 "color4"
#define XtNarc4 "arc4"
#define XtNlabel4 "label4"

#define XtCHeadline "Headline"
#define XtCPlacement "Placement"
#define XtCSpacing "Spacing"
#define XtCNumberSectors "NumberSectors"
#define XtCColor1 "Color1"
#define XtCArc1 "Arc1"
#define XtCLabel1 "Label1"
#define XtCColor2 "Color2"
#define XtCArc2 "Arc2"
#define XtCLabel2 "Label2"
#define XtCColor3 "Color3"
#define XtCArc3 "Arc3"
#define XtCLabel3 "Label3"
#define XtCColor4 "Color4"
#define XtCArc4 "Arc4"
#define XtCLabel4 "Label4"

#define XcmwNUM_SECTORS    4
#define XcmwDEFAULT_HEIGHT 50

/*
 * convenience functions
 */

extern void XcmwUpdateSectors(Widget, int *);
/* update arcs and redraw sectors */

#endif /* _CircMeter_h */



