#ifndef __DOC_H__
#define __DOC_H__

#include "browser.h"   /* for DilloDoc */

/* macros for documents */
#define DD_HAS_FOCUS(dd,bw) bw->dd == dd

void a_Doc_init(void);
void a_Doc_stop(DilloDoc *dd);
void a_Doc_clean(DilloDoc *dd);
void a_Doc_title_set(DilloDoc *dd, gchar *title);
void a_Doc_location_set(DilloDoc *dd, gchar *location);
void a_Doc_remove_client(DilloDoc *dd, gint ClientKey);
void a_Doc_close_client(DilloDoc *dd, gint ClientKey);
void a_Doc_add_client(DilloDoc *dd, gint Key, gint Root);
void a_Doc_add_url(DilloDoc *dd, const DilloUrl *Url, gint Flags);
void a_Doc_destroy(DilloDoc *dd);
void a_Doc_set_cursor(DilloDoc *dd, GdkCursorType CursorType);
void a_Doc_set_name(DilloDoc *dd, gchar *name);
void a_Doc_set_parent(DilloDoc *dd, DilloDoc *parent);
void a_Doc_set_browserwindow(DilloDoc *dd, BrowserWindow *bw);
void a_Doc_progress_update(DilloDoc *dd);
GList * a_Doc_get_visible_children(DilloDoc *dd);
DilloDoc * a_Doc_get_by_docwin(GtkWidget *docwin);
DilloDoc * a_Doc_get_by_name(gchar *name);
DilloDoc * a_Doc_get_root(DilloDoc *dd);
DilloDoc * a_Doc_new(void);

#endif /* __DOC_H__ */
