/*
 * File: bookmark.c
 *
 * Copyright 2002 Jorge Arellano Cid <jcid@inf.utfsm.cl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "browser.h"
#include "history.h"
#include "menu.h"
#include "capi.h"
#include "nav.h"
#include "misc.h"



/*
 * Initialize the bookmarks module
 */
void a_Bookmarks_init(void)
{
   /* simple isn't it? ;) */
}

/*
 * Have a short chat with the bookmarks server,
 * and finally ask it to add a new bookmark.
 * (this is an example of dpi chat)
 */
void a_Bookmarks_chat_add(DilloDoc *Dd, char *Cmd, char *answer)
{
   char *cmd1 = "<dpi cmd='chat' msg='Hi server'>";
   char *cmd2 = "<dpi cmd='chat' msg='I want to set a bookmark'>";
   char *cmd3 = "<dpi cmd='chat' msg='Sure it is!'>";
   static DilloDoc *dd = NULL;
   static gchar *cmd4 = NULL;

   //g_print("a_Bookmarks_chat_add\n answer=%s\n", answer ? answer : "(null)");

   if (Dd)
      dd = Dd;
   if (!cmd4 && Cmd)
      cmd4 = g_strdup(Cmd);

   if (!answer) {
      a_Capi_dpi_send_cmd(dd, cmd1, "bm", 1);

   } else {
      /* we have an answer */
      if (answer) {
         if (*answer == 'H') {
            /* "Hi browser" */
            a_Capi_dpi_send_cmd(dd, cmd2, "bm", 0);
         } else if (*answer == 'I') {
            /* "Is it worth?" */
            a_Capi_dpi_send_cmd(dd, cmd3, "bm", 0);
         } else if (*answer == 'O') {
            /* "OK, send it!" */
            a_Capi_dpi_send_cmd(dd, cmd4, "bm", 0);
            g_free(cmd4);
            cmd4 = NULL;
         }
      }
   }
}

/*
 * Add the new bookmark through the bookmarks server
 */
void a_Bookmarks_add(DilloDoc *dd, DilloUrl *url)
{
   gchar *title, *t;
   gchar *cmd = NULL;

   g_return_if_fail(url != NULL && dd != NULL);

   /* if the page has no title, we'll use the url string */
   title = (gchar *) a_History_get_title_by_url(url, 1);
   title = (t = a_Misc_stuff_chars(title, "'\"")) ? t : title;

   cmd = g_strdup_printf("<dpi cmd='add_bookmark' url='%s' title='%s'>",
                         URL_STR(url), title);
   a_Bookmarks_chat_add(dd, cmd, NULL);
   g_free(cmd);
}

/*
 * Request the server to show the bookmarks
 */
void a_Bookmarks_show(DilloDoc *dd)
{
   DilloUrl *url;

   url = a_Url_new("dpi:/bm/", NULL, 0, 0);
   a_Nav_push(dd, url);
   a_Url_free(url);

/*
   DilloUrl *url;
   DilloWeb *Web;

   url = a_Url_new("dpi:/bm/", NULL, 0, 0);
   Web = a_Web_new(url);
   Web->bw = bw;
   Web->flags |= WEB_RootUrl;
   a_Capi_open_url(Web, NULL, NULL);
   a_Url_free(url);
*/
}

