
/*
 * widget.c
 *
 * Copyright (C) 1993, 1994, 1995, John D. Kilburg (john@cs.unlv.edu)
 *
 * Note that much of this code was actually written by Jim.Rees@umich.edu.
 * The messed up parts were written by john.
 *
 * See copyright.h for details.
 */
#include "copyright.h"
#include "options.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Toggle.h>

#include <X11/Xaw/Cardinals.h>

#include <X11/xpm.h>

#include "ScrollText.h"

#ifndef __STDC__
#define _NO_PROTO 1
#endif

#include "HTML.h"

#include "common.h"
#include "url.h"
#include "mime.h"
#include "document.h"
#include "convert.h"
#include "widget.h"

#ifdef ULRIC_WAS_HERE
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

//#include "../../xcommon/xcommon.h"

extern AppResources root;	/* from main.c */

Widget menubox, buttonbox;

static unsigned long highlight_color;
static unsigned long unhighlight_color;


static void NewChimera()
{
	if (!fork()) {
		execlp(siaghelp, "Siaghelp", "-geometry", "600x400", NULL);
		exit(0);
	}
}

static void spawn(char *p)
{
	char *argv[20], cmd[1024];
	int argc = 0;

	strncpy(cmd, p, 1000);
	for (p = strtok(cmd, " \t\r\n");
		p && argc < 20;
		p = strtok(NULL, " \t\r\n")) {
		argv[argc++] = p;
	}
	argv[argc] = NULL;
	if (!fork()) {
		execvp(argv[0], argv);
		exit(0);
	}
}

static void ToolsTerminal()
{
	spawn("xterm -sb -sl 500 -j -ls -fn 7x14");
}

static void ToolsFiles()
{
	spawn("files");
}

static void ToolsPW()
{
	spawn("pw");
}

static void ToolsSiag()
{
	spawn("siag");
}

static void ToolsEgon()
{
	spawn("egon");
}

extern void Siaghelp(char *);

static void HelpContents()
{
	Siaghelp("~/.chimera/help.html");
}

static void AboutChimera()
{
	Siaghelp("~/.chimera/chimera.1x.html");
}

static void myXawListUnhighlight(Widget w, XEvent *event,
			String *params, Cardinal *num_params)
{
//	XawListUnhighlight(w);
}

static void myXawListHighlight(Widget w, XEvent *event,
			String *params, Cardinal *num_params)
{
//	int t=atoi(params[0]);
//	XawListHighlight(w, t);
}

static void siaghelp_action(Widget w, XEvent *event,
			String *params, Cardinal *num_params)
{
	char b[256];

	sprintf(b, "file://localhost%s/chimera-1.71/docs/%s",
			docdir, params[0]);
	if (!fork()) {
		execlp(siaghelp, "Siaghelp", "-geometry", "600x400", b, NULL);
		exit(0);
	}
}

static XtActionsRec actions[] = {
	{"siaghelp", siaghelp_action},
	{"tooltip", NULL},
	{"draw-input", NULL},
	{"siag-unhighlight", myXawListUnhighlight},
	{"siag-highlight", myXawListHighlight}
};

typedef struct _menu_struct {
	String name;
	XtPointer function;
} menu_struct;

static menu_struct mnuFile_names[] = {
	{"mnuFileNew", NewChimera},
	{"mnuFileOpen", OpenAction},
	{"mnuFileSave", FileAction},
	{"-", NULL},
	{"mnuFileExit", Quit},
	{NULL, NULL}
};

static menu_struct mnuView_names[] = {
	{"mnuViewReload", Reload},
	{"mnuViewSource", Source},
	{"mnuViewFind", SearchAction},
	{NULL, NULL}
};

static menu_struct mnuGo_names[] = {
	{"mnuGoBack", Back},
	{"mnuGoFwrd", Forward},
	{"mnuGoHome", Home},
	{"mnuGoCancel", Cancel},
	{"-", NULL},
	{"mnuGoBookmark", BookmarkAction},
	{NULL, NULL}
};

static menu_struct mnuTools_names[] = {
	{"mnuToolsTerminal", ToolsTerminal},
	{"mnuToolsFiles", ToolsFiles},
	{"mnuToolsPW", ToolsPW},
	{"mnuToolsSiag", ToolsSiag},
	{"mnuToolsEgon", ToolsEgon},
	{NULL, NULL}
};

static menu_struct mnuHelp_names[] = {
	{"mnuHelpContents", HelpContents},
	{"-", NULL},
	{"mnuHelpAboutChimera", AboutChimera},
	{NULL, NULL}
};

static void make_menu(menu_struct menu_entry_names[], Widget menu)
{
	int i;
	Widget entry;

	for (i = 0; menu_entry_names[i].name; i++) {
		String item = menu_entry_names[i].name;
		if (item[0] == '-')	/* line pane */
			entry = XtCreateManagedWidget(item,
					smeLineObjectClass, menu, NULL, 0);
		else {
			entry = XtCreateManagedWidget(item,
					smeBSBObjectClass, menu, NULL, 0);
			XtAddCallback(entry,
				XtNcallback, menu_entry_names[i].function,
				NULL);
		}
	}
}

static void init_menu(Widget box)
{
	Widget btnFile, mnuFile, btnView, mnuView,
		btnGo, mnuGo, btnTools, mnuTools, btnHelp, mnuHelp;

	btnFile = XtVaCreateManagedWidget("btnFile",
		menuButtonWidgetClass, box, NULL);
	mnuFile = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnFile, NULL);
	make_menu(mnuFile_names, mnuFile);

	btnView = XtVaCreateManagedWidget("btnView",
		menuButtonWidgetClass, box, NULL);
	mnuView = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnView, NULL);
	make_menu(mnuView_names, mnuView);

	btnGo = XtVaCreateManagedWidget("btnGo",
		menuButtonWidgetClass, box, NULL);
	mnuGo = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnGo, NULL);
	make_menu(mnuGo_names, mnuGo);

	btnTools = XtVaCreateManagedWidget("btnTools",
		menuButtonWidgetClass, box, NULL);
	mnuTools = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnTools, NULL);
	make_menu(mnuTools_names, mnuTools);

	btnHelp = XtVaCreateManagedWidget("btnHelp",
		menuButtonWidgetClass, box, NULL);
	mnuHelp = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnHelp, NULL);
	make_menu(mnuHelp_names, mnuHelp);
}

static Widget make_toolbar(char *name, void (*cmd)(), Widget pw,
		char *pm)
{
	Widget w;
	XpmAttributes xa;
	Pixmap pm_return;
	int result;
	XpmColorSymbol symbol;
	Pixel color;
	char fn[1024];

	if (pm[0] == '/') strcpy(fn, pm);
	else sprintf(fn, "%s/common/bitmaps/%s", datadir, pm);

	XtVaGetValues(pw, XtNbackground, &color, (char *)0);
	xa.closeness = 40000;
	xa.exactColors = False;
	xa.valuemask = XpmCloseness | XpmExactColors;
	if (pw == None) return None;

	w = XtVaCreateManagedWidget(name,
		commandWidgetClass, pw,
		XtNforeground, color,
		(char *)0);
	symbol.name = NULL;
	symbol.value = "none";
	symbol.pixel = color;
	xa.colorsymbols = &symbol;
	xa.numsymbols = 1;
	xa.valuemask |= XpmColorSymbols;

	result = XpmReadFileToPixmap(XtDisplay(w),
		XRootWindowOfScreen(XtScreen(w)),
		fn, &pm_return, NULL, &xa);
	if (result != XpmSuccess) {
		fprintf(stderr, "XpmReadFileToPixmap returns %s for %s.\n",
			XpmGetErrorString(result),name);
		return NULL;
	}

	XtVaSetValues(w,
		XtNbitmap, pm_return,
		(char *)0);

	XtAddCallback(w, XtNcallback, cmd, NULL);
	return w;
}

/* The toolbar */
/* quit open home back source reload file help bookmark search cancel deferpix
*/
static void init_toolbar(Widget box)
{
/*	Widget tbQuit, tbNew, tbOpen, tbHome, tbBack,
		tbReload, tbFile, tbHelp, tbCopy,
		tbSearch, tbCancel;

	tbNew = make_toolbar("tbNew", NewChimera, box, "new.xpm");
	tbOpen = make_toolbar("tbOpen", OpenAction, box, "fld_open.xpm");
	tbHome = make_toolbar("tbHome", Home, box, "home.xpm");
	tbBack = make_toolbar("tbBack", Back, box, "back.xpm");
	tbReload = make_toolbar("tbReload", Reload, box, "reload.xpm");
	tbFile = make_toolbar("tbFile", FileAction, box, "floppy3.xpm");
	tbHelp = make_toolbar("tbHelp", HelpContents, box, "info.xpm");
	tbCopy = make_toolbar("tbCopy", HelpCopying, box, "copyright.xpm");
	tbSearch = make_toolbar("tbSearch", SearchAction, box, "search.xpm");
	tbCancel = make_toolbar("tbCancel", Cancel, box, "cancel.xpm");
*/
	Widget tbQuit, tbNew, tbOpen, tbHome, tbBack, tbFwrd,
		tbReload, tbFile, tbHelp, tbBookmark,
		tbSearch, tbCancel/*, tbDeferPix*/;

//	tbQuit = make_toolbar("tbQuit", Quit, box, "quit.xpm");
//	tbNew = make_toolbar("tbNew", NewChimera, box, "new.xpm");
//	tbOpen = make_toolbar("tbOpen", OpenAction, box, "fld_open.xpm");
//	tbHelp = make_toolbar("tbHelp", HelpContents, box, "question.xpm");
	tbBack = make_toolbar("tbBack", Back, box, "back.xpm");
	tbFwrd = make_toolbar("tbFwrd", Forward, box, "forward.xpm");
	tbReload = make_toolbar("tbReload", Reload, box, "reload.xpm");
	tbHome = make_toolbar("tbHome", Home, box, "home.xpm");
	tbFile = make_toolbar("tbFile", FileAction, box, "floppy3.xpm");
	tbBookmark = make_toolbar("tbBookmark", BookmarkAction, box, "book-open.xpm");
	tbSearch = make_toolbar("tbSearch", SearchAction, box, "search.xpm");
	tbCancel = make_toolbar("tbCancel", Cancel, box, "cancel.xpm");
}
#else

static struct ButtonTable {
  char *name;
  Widget w;
  int wc;			/* 0: command widget;  1: toggle widget */
  void (*cb)();
} ButtonTable[] = {
  {"quit",      NULL, 0, Quit},
  {"open",	NULL, 0, OpenAction},
  {"home",	NULL, 0, Home},
  {"back",	NULL, 0, Back},
  {"source",	NULL, 0, Source},
  {"reload",	NULL, 0, Reload},
  {"file",      NULL, 0, FileAction},
  {"help",	NULL, 0, Help},
  {"cancel",    NULL, 0, Cancel},
  {"bookmark",	NULL, 0, BookmarkAction},
  {"search",    NULL, 0, SearchAction},
  {"deferpix",  NULL, 1, DeferPix},
  {NULL,        NULL, 0, NULL},
};

static void
AddButtons(r, box, list)
AppResources *r;
Widget box;
char *list;
{
  char name[256];
  struct ButtonTable *btp;

  list = alloc_string(list);

  while (sscanf(list, " %[^,]", name) == 1)
  {
    /*
     * Find the listed button and create its widget
     */
    for (btp = &ButtonTable[0]; btp->name != NULL; btp++)
    {
      if (!strcasecmp(btp->name, name))
      {
	WidgetClass wc =
	    (btp->wc == 0) ? commandWidgetClass : toggleWidgetClass;
	btp->w = XtCreateManagedWidget(btp->name,
				       wc,
				       box,
				       NULL, ZERO);
	XtAddCallback(btp->w, XtNcallback, btp->cb, r);
	break;
      }
    }

    /*
     * Fill in the entry in AppResources for the widget.
     */
    if (!strcasecmp(name, "open"))
      r->load = btp->w;
    else if (!strcasecmp(name, "home"))
    {
      r->home = btp->w;
      XtSetSensitive(r->home, False);
    }
    else if (!strcasecmp(name, "back"))
    {
      r->back = btp->w;
      XtSetSensitive(r->back, False);
    }
    else if (!strcasecmp(name, "source"))
      r->source = btp->w;
    else if (!strcasecmp(name, "reload"))
      r->reload = btp->w;
    else if (!strcasecmp(name, "file"))
      r->file = btp->w;
    else if (!strcasecmp(name, "help"))
      r->help = btp->w;
    else if (!strcasecmp(name, "bookmark"))
      r->bookmark = btp->w;
    else if (!strcasecmp(name, "cancel"))
      r->cancel = btp->w;
    else if (!strcasecmp(name, "search"))
      r->search = btp->w;
    else if (!strcasecmp(name, "quit"))
      r->quit = btp->w;
    else if (!strcasecmp(name, "deferpix"))
      r->deferpix = btp->w;

    /*
     * Skip to the next comma-delimited item in the list
     */
    while (*list && *list != ',')
      list++;
    if (*list == ',')
      list++;
  }

  return;
}
#endif	/* ULRIC_WAS_HERE */

/*
 * CreateWidgets
 *
 * Create the command and box widgets.
 */
void
CreateWidgets(r)
AppResources *r;
{
  Widget paned, form;
  Arg args[5];

  /*
   * Main window pane
   */
  paned = XtCreateManagedWidget("paned",
                                panedWidgetClass, r->toplevel, 
                                NULL, ZERO);

#ifdef ULRIC_WAS_HERE
	XtAppAddActions(root.appcon, actions, XtNumber(actions));

	menubox = XtVaCreateManagedWidget("menubox",
			boxWidgetClass, paned, NULL);
	init_menu(menubox);
	buttonbox = XtVaCreateManagedWidget("buttonbox",
			boxWidgetClass, paned, NULL);
	init_toolbar(buttonbox);

	highlight_color = WhitePixel(XtDisplay(menubox),
		DefaultScreen(XtDisplay(menubox)));
	XtVaGetValues(menubox,
		XtNbackground, &unhighlight_color,
		NULL);
//	tooltip_init(r->toplevel, highlight_color, unhighlight_color);

#else

  /*
   * Button pane(s)
   */
  if (r->button1Box && *r->button1Box)
  {
    box = XtCreateManagedWidget("box1", boxWidgetClass, paned, NULL, ZERO);
    AddButtons(r, box, r->button1Box);
  }

  if (r->button2Box && *r->button2Box)
  {
    box = XtCreateManagedWidget("box3", boxWidgetClass, paned, NULL, ZERO);
    AddButtons(r, box, r->button2Box);
  }


  /*
   * Third pane. Title display.
   */
  if (r->showTitle)
  {
    form = XtCreateManagedWidget("box5",
				formWidgetClass, paned,
				NULL, ZERO);
    
    XtCreateManagedWidget("titlelabel",
			  labelWidgetClass, form,
			  NULL, ZERO);
    
    r->titledisplay = XtCreateManagedWidget("titledisplay",
					    scrollingTextWidgetClass, form,
					    NULL, ZERO);
    r->titledisplay = XtNameToWidget(r->titledisplay, "text");
  }
  else
  {
    r->titledisplay = 0;
  }

#endif	/* ULRIC_WAS_HERE */

  /*
   * Fourth pane.  URL display.
   */
  if (r->showURL)
  {
    form = XtCreateManagedWidget("box4",
				formWidgetClass, paned,
				NULL, ZERO);
    
    XtCreateManagedWidget("urllabel",
			  labelWidgetClass, form,
			  NULL, ZERO);
    
    r->urldisplay = XtCreateManagedWidget("urldisplay",
					  scrollingTextWidgetClass, form,
					  NULL, ZERO);
    r->urldisplay = XtNameToWidget(r->urldisplay, "text");
  }
  else
  {
    r->urldisplay = 0;
  }

  /*
   * [rwmcm,GN] `Sixth' (really Fifth) pane, the live anchor display
   * External name changed to `hrefdisplay' so 1.70p0 resources won't
   * interfere with 1.70p1 ones --GN 1997May22
   */
  if (r->showLiveAnchors)
  {
    form = XtCreateManagedWidget("box6",
				 formWidgetClass, paned,
				 NULL, ZERO);

    XtCreateManagedWidget("hreflabel",
			  labelWidgetClass, form,
			  NULL, ZERO);

    r->anchordisplay = XtCreateManagedWidget("hrefdisplay",
					     scrollingTextWidgetClass, form,
					     NULL, ZERO);
    r->anchordisplay = XtNameToWidget(r->anchordisplay, "text");
  }
  else
  {
    r->anchordisplay = 0;
  }

  /*
   * `Fifth' (really Sixth) pane, the HTML viewing area
   */
  r->w = XtCreateManagedWidget("html",
                              htmlWidgetClass, paned,
                              NULL, ZERO);
  XtAddCallback(r->w, WbNanchorCallback, Anchor, r);
  if (r->showLiveAnchors)
  {
    XtSetArg(args[0], WbNpointerMotionCallback, LiveAnchorCallback);
    XtSetValues(r->w, args, 1);
  }

  /*
   * Set some callbacks for the HTML widget.
   */
  XtSetArg(args[0], WbNresolveImageFunction, ImageResolve);
  XtSetArg(args[1], WbNpreviouslyVisitedTestFunction, VisitTest);
  XtSetValues(r->w, args, 2);

  XtAddCallback(r->w, WbNlinkCallback, LinkCB, (XtPointer)0);
  XtAddCallback(r->w, WbNsubmitFormCallback, SubmitForm, (XtPointer)0);

  return;
}


