#ifndef _XtDiffDisplayPrivate_h
#define _XtDiffDisplayPrivate_h

#include <X11/XawPlus/SimpleP.h>

#include "DiffDisplay.h"
#include "diff.h"
#include "xwindiff.h"

/***********************************************************************/
/* DiffDisplay Widget Private Data                                     */
/***********************************************************************/

typedef struct {
     int notused;   /* No new procedures */
} DiffDisplayClassPart;

/* Full class record declaration */
typedef struct _DiffDisplayClassRec {
    CoreClassPart	  core_class;
    SimpleClassPart       simple_class;
    DiffDisplayClassPart  diff_widget_class;
} DiffDisplayClassRec;

extern DiffDisplayClassRec diffDisplayClassRec;

typedef struct _DiffDisplayPart {
  /* public fields first */
  Pixel foreground;		/* Text colour */
  Pixel background;             /* default background color */
  Pixel left_color;             /* Color for left hand stuff */
  Pixel right_color;            /* Color for right hand stuff */
  Dimension indent;		/* amount to indent the file. */
  XFontStruct *font;     	/* The font. */
  Boolean show_leftnums;        /* show left file line numbers. */
  Boolean show_rightnums;       /* show right file line numbers. */
  Boolean show_left;            /* show left file. */
  Boolean show_right;           /* show right file. */
  Boolean show_both;            /* show both files. */

  /* private fields */
  Widget bar;			/* The scrollbar. */
  int font_height;		/* the height of the font. */
  int font_width;               /* the width of the font. */
  Dimension offset;		/* Drawing offset because of scrollbar. */
  GC move_gc;			/* GC to use when moving the text. */
  GC normal_gc;                 /* gc for drawing. */
  GC left_gc;                   /* gc for drawing left-only text. */
  GC right_gc;                  /* gc for drawing right-only text. */
  GC wipe_gc;                   /* gc to use when clearing areas. */

  int line_pointer;		/* The line that currently is at the top
				   of the window being displayed. */
  int curpos;                   /* Current highlighted position */
  int lines;			/* number of lines in the file. */
  int digits;                   /* maximum digits needed for a linenumber. */

  struct change *script;        /* The script of differences. */
  DirEntry *filelist;           /* Array of file descriptions. */
  int largestname;              /* Biggest name in the list. */
  int listsize;                 /* Size of array. */
  int selectedfile;             /* Currently selected file. */
} DiffDisplayPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _DiffDisplayRec {
    CorePart	      core;
    SimplePart        simple;
    DiffDisplayPart   diff;
} DiffDisplayRec;

#endif /* _XtDiffDisplayPrivate_h */
