
#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>

#include "flist.h"
#include "global.h"
#include "dragdrop.h"
#include "lowlevel.h"

extern GtkWidget *maketree();
extern void tree_remove_dir(char *dir);
extern void tree_add_dir(char *dir, gboolean ie_flag);
extern void change_to_dir(GtkWidget *widget, char *dir);

void add_to_expanded_list (GtkWidget *widget, gpointer *path);
void remove_from_expanded_list (GtkWidget *widget, gpointer *path);
GSList *refreshtree_expander (GSList *old_expanded_objects);

static void destroy_tree(gpointer data);
static void expand_tree (GtkWidget *ctree, GtkCTreeNode *parent_node);
static void select_tree_item (GtkWidget *node, GtkCTreeNode *row, gint column, gpointer data);
static int node_compare_func (const void *a, const void *b);

extern GtkWidget *dir_tree;
extern GtkCTreeNode *RootNode;
extern GtkCTreeNode *current_dir_node;
extern gint last_entry, cur_entry, direc;

GSList *expanded_objects = NULL;
gint tree_pos = -1;

/*
 * maketree creates a tree widget and a root tree item.
 * it connects all signals to the tree
 */
GtkWidget *maketree ()
{
	GtkWidget *newtree;
	gchar *RootText = "/";
	gchar *node_text = "dummy";
	DirNode *dirnode;
	GtkCTreeNode *node;
	/* The tree */
	newtree = gtk_ctree_new(1,0);

 	/* Tree config */
	gtk_ctree_set_indent (GTK_CTREE(newtree),13);
	gtk_clist_set_selection_mode(GTK_CLIST(newtree), GTK_SELECTION_SINGLE);
  	gtk_ctree_set_line_style (GTK_CTREE(newtree),GTK_CTREE_LINES_DOTTED);
	gtk_ctree_set_expander_style (GTK_CTREE(newtree),GTK_CTREE_EXPANDER_SQUARE);
	gtk_clist_set_column_auto_resize (GTK_CLIST(newtree),0,TRUE);

	// Connect signals to tree and drag&drop
	gtk_signal_connect(GTK_OBJECT(newtree),"tree_expand",GTK_SIGNAL_FUNC(expand_tree),NULL);
	gtk_signal_connect(GTK_OBJECT(newtree),"tree_select_row",GTK_SIGNAL_FUNC(select_tree_item),NULL);

	gtk_drag_dest_set (newtree, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, target_table, 1, GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_LINK);
	gtk_signal_connect(GTK_OBJECT(newtree),"drag_data_received", GTK_SIGNAL_FUNC(target_data_received), NULL);
	gtk_signal_connect(GTK_OBJECT(newtree),"drag_motion", GTK_SIGNAL_FUNC(target_data_motioned), NULL);
	gtk_signal_connect(GTK_OBJECT(newtree),"drag_leave", GTK_SIGNAL_FUNC(target_data_left), NULL);

	/* Create root node */
	RootNode = gtk_ctree_insert_node(GTK_CTREE(newtree),NULL,NULL,&RootText,4,NULL, NULL, NULL, NULL, FALSE, FALSE);

	dirnode = g_malloc0(sizeof(DirNode));
	dirnode->path = g_strdup("/");
	gtk_ctree_node_set_row_data_full(GTK_CTREE(newtree), RootNode, dirnode, destroy_tree);

	/* Insert dummy node to display: '+' */
	node = gtk_ctree_insert_node(GTK_CTREE(newtree),RootNode,NULL,&node_text,4, NULL,NULL,NULL,NULL,TRUE,TRUE);

	/* Open root node */
	gtk_ctree_expand(GTK_CTREE(newtree),RootNode);

	gtk_widget_show_all(newtree);
//	dir_tree = newtree;
	return newtree;
}

/*
 * expand_tree is being called if one clicks the + sign beside a dir in the tree.
 * if this is the first time, the dummy node gets removed and the list gets filled with
 * the proper items.
 */
static void expand_tree (GtkWidget *ctree, GtkCTreeNode *parent_node)
{
	DIR *dir;
	struct dirent *dirent;
	gchar *path;
	gchar *text;
	gchar *dummy = "dummy";
	struct stat statbuf;
	GtkCTreeNode *node, *sub_node;
	DirNode *parent_dirnode, *dirnode;
	gboolean has_subdir = FALSE;

	parent_dirnode = gtk_ctree_node_get_row_data(GTK_CTREE(ctree), parent_node);
	if(!parent_dirnode->scanned) {
		gtk_clist_freeze(GTK_CLIST(ctree));
		node = gtk_ctree_find_by_row_data(GTK_CTREE(ctree), parent_node, NULL);
		gtk_ctree_remove_node(GTK_CTREE(ctree),node);
		if( (dir=opendir(parent_dirnode->path)) ) {
			while( (dirent=readdir(dir)) ) {
				path = completename(parent_dirnode->path,dirent->d_name);
				stat(path,&statbuf);
				if (S_ISDIR(statbuf.st_mode) && (strcmp (dirent->d_name,".")!=0) && (strcmp (dirent->d_name,"..")!=0)) {
					dirnode = g_malloc0(sizeof(DirNode));
					dirnode->path = g_strdup(path);
					text = dirent->d_name;
					if(dir_has_subdirs(dirnode->path))
						has_subdir=TRUE;
					else
						has_subdir=FALSE;
					node = gtk_ctree_insert_node(GTK_CTREE(ctree), parent_node,NULL,&text,4, NULL, NULL, NULL, NULL, !has_subdir, FALSE);
					gtk_ctree_node_set_row_data_full(GTK_CTREE(ctree),node, dirnode,destroy_tree);

					if(has_subdir)
						sub_node=gtk_ctree_insert_node(GTK_CTREE(ctree), node,NULL,&dummy,4, NULL,NULL,NULL,NULL,FALSE,FALSE);
				}
				g_free(path);
			}
			closedir(dir);
			gtk_ctree_sort_node(GTK_CTREE(ctree),parent_node);
		}
		gtk_clist_thaw(GTK_CLIST(ctree));
		parent_dirnode->scanned=TRUE;
	}
}

/*
 * destroy_tree is a function that frees memory if a tree item is destroyed.
 */
static void destroy_tree(gpointer data)
{
	DirNode *node=data;
	g_free(node->path);
	g_free(node);
}

/* this function makes the proper calls to fill the list with a new directory
 * if one is selected in the tree.
 */
static void select_tree_item (GtkWidget *node, GtkCTreeNode *row, gint column, gpointer data)
{
	DirNode *tmpnode;
	tmpnode = gtk_ctree_node_get_row_data (GTK_CTREE(node), row);
	fillist (NULL, (gpointer *)tmpnode->path);
}

/*
 * call this to remove a dir from the tree
 * !!! NOTE !!! destructive to *dir if not valid
 */
void tree_remove_dir (char *dir)
{
	GtkCTreeNode *node;
	char *parent_dir, *name, *grand_parent_dir, *parent_name;
	GtkCTreeNode *parentnode;
	int leaf_test;
	tree_pos = -1;
	node = gtk_ctree_find_by_row_data_custom (GTK_CTREE(dir_tree), NULL, dir, node_compare_func);
	if (node !=NULL)
		gtk_ctree_remove_node (GTK_CTREE(dir_tree), node);

	// now see if we have to remove the + sign (by making the thing a leaf)

	if(!(parent_dir = dir_parent_dir (dir, &name))) return;

	if (!dir_has_subdirs(parent_dir)) {
		tree_pos = -1;
		parentnode = gtk_ctree_find_by_row_data_custom (GTK_CTREE(dir_tree), NULL, parent_dir, node_compare_func);
		if (parentnode == NULL){tree_pos = -1; return;}
		gtk_ctree_get_node_info (GTK_CTREE(dir_tree), parentnode, NULL, NULL, NULL, NULL, NULL, NULL, &leaf_test, NULL);
		if (!leaf_test) {
			// it has no subdirs, but it is not a leaf
			if((grand_parent_dir  = dir_parent_dir(parent_dir, &parent_name)))
				gtk_ctree_set_node_info (GTK_CTREE(dir_tree), parentnode, parent_name, 4, NULL, NULL, NULL, NULL, TRUE, FALSE);
		}
	}
}

/*
 * function used to search dirs in trees
 */
static int node_compare_func (const void *a, const void *b)
{
	// none of these should be NULL
	if (!a || !b || !((DirNode *)a)->path)
	{
		tree_pos = -1;
		return -1;
	}
	if(tree_pos < 0)
		tree_pos = 0; 
	else
		tree_pos++;
	return strcmp(((DirNode *)a)->path, (gchar *)b);
}

/*
 * automagically add a dir to the tree if it should be visible
 * insert/expand the found directory depending on ie_flag, true=insert
 */
void tree_add_dir (char *dir, gboolean ie_flag)
{
	DirNode *childdirnode, *parentdirnode;
	GtkCTreeNode *parentnode, *childnode, *sub_node;
	char has_subdir;
	char *dummy = "dummy";
	char *parent_dir, *name;
	char *grand_parent_dir, *grand_name;
	int leaf_test;

	char* tmp = dir + strlen(dir) -1;
	if((tmp - dir > 1) && (*tmp == '/')) *tmp = '\0';
	parent_dir = dir_parent_dir(dir, &name);
	if(!(parent_dir = dir_parent_dir (dir, &name))){
		parent_dir = "/";
		name = dir[0] ? &dir[1] : &dir[0];
	}

	tree_pos = -1;
	parentnode = gtk_ctree_find_by_row_data_custom (GTK_CTREE(dir_tree), NULL, parent_dir, node_compare_func);
	if (parentnode !=NULL) {
		parentdirnode = (DirNode *)gtk_ctree_node_get_row_data (GTK_CTREE(dir_tree), parentnode);
		if (parentdirnode->scanned) {
			childdirnode = g_malloc0(sizeof(DirNode));
			childdirnode->path = completename (parent_dir, name);
/*			if(access(childdirnode->path, F_OK)) {
				tree_remove_dir (childdirnode->path);
				current_dir_node = parentnode;
				free(childdirnode);
				return;
			}
*/			if (dir_has_subdirs(childdirnode->path))
				has_subdir = TRUE;
			else
				has_subdir = FALSE;

//printf("Here dir_tree='%lx' childnode='%lx'.\n",dir_tree,childnode);
			if(ie_flag){ // do insert node
				childnode = gtk_ctree_insert_node (GTK_CTREE(dir_tree), parentnode, NULL, &name, 4, NULL, NULL, NULL, NULL, !has_subdir, FALSE);
				gtk_ctree_node_set_row_data_full (GTK_CTREE(dir_tree), childnode, childdirnode, destroy_tree);
				if (has_subdir)
					sub_node = gtk_ctree_insert_node(GTK_CTREE(dir_tree), childnode, NULL, &dummy, 4, NULL, NULL, NULL, NULL, FALSE, FALSE);
				gtk_ctree_sort_node (GTK_CTREE(dir_tree), parentnode);
			} else { // do expand node
				tree_pos = -1;
				childnode = gtk_ctree_find_by_row_data_custom (GTK_CTREE(dir_tree), NULL, childdirnode->path, node_compare_func);
				if(childnode && !GTK_CTREE_ROW(childnode)->expanded) {
//printf("Here2a.\n");
//printf("Here dir_tree->window='%lx' dir_tree->parent='%lx'.\n",dir_tree->window,dir_tree->parent);
				  gtk_ctree_expand (GTK_CTREE(dir_tree), childnode);
//printf("Here2b.\n");
				}
				if(current_dir_node && childnode) gtk_ctree_unselect (GTK_CTREE(dir_tree), childnode);
				current_dir_node = childnode;
			}

		} else { // OK, now test if a the parent needs a + sign on the screen
			gtk_ctree_get_node_info (GTK_CTREE(dir_tree), parentnode, NULL, NULL, NULL, NULL, NULL, NULL, &leaf_test, NULL);
			if (leaf_test) {
				if(!(grand_parent_dir = dir_parent_dir (parent_dir, &grand_name))) return;
				gtk_ctree_set_node_info (GTK_CTREE(dir_tree), parentnode, grand_name, 4, NULL, NULL, NULL, NULL, FALSE, FALSE);
				/* first tell gtk it isnt a leaf, then insert dummy node */
				sub_node = gtk_ctree_insert_node(GTK_CTREE(dir_tree), parentnode, NULL,  &dummy,4, NULL, NULL, NULL, NULL, FALSE, FALSE);
				if (sub_node == NULL) printf ("ERROR\n");
//				else printf ("node inserted succesfully\n");
			}
		}
	}
	return;
}
