
#include <unistd.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>
#include <dirent.h>
#include <gtk/gtk.h>

#include "intl.h"
#include "gtypes.h"
#include "global.h"
#include "toolbar.h"
#include "search.h"

#include "xpm/goback.xpm"
#include "xpm/goforw.xpm"
#include "xpm/parent_folder.xpm"
#include "xpm/refresh.xpm"
#include "xpm/search.xpm"
#include "xpm/cut.xpm"
#include "xpm/copy.xpm"
#include "xpm/paste.xpm"
#include "xpm/remove.xpm"
#include "xpm/rename.xpm"
//#include "xpm/about.xpm"

extern char *dir_parent_dir(char *dir, char **rest);
extern void tree_add_dir (char *dir, gboolean ie_flag);
extern void refreshlist();
extern void rename_selection(GtkWidget *w, gpointer *p);
extern void delete_selection(GtkWidget *w, gpointer *p);
extern void paste_clipboard(GtkWidget *widget, gpointer *data);
extern void selection_to_clipboard (GtkWidget *widget, gpointer *action);
extern void menu_edit_cut(GtkWidget *widget, gpointer data);
extern void menu_edit_copy(GtkWidget *widget, gpointer data);
extern void menu_edit_paste(GtkWidget *widget, gpointer data);

extern void	dir_entry_enter (GtkWidget *widget, GtkWidget *entry);
extern void prev_dir(GtkWidget *widget, GtkWidget *aentry);
extern void next_dir(GtkWidget *widget, GtkWidget *aentry);

extern GtkWidget *mainwindow;	// main window
extern GtkWidget *treewin;		// tree window
extern GtkWidget *file_list;	// directory file list
extern GtkWidget *dir_tree;		// root GTK_CTREE
extern GtkCTreeNode *current_dir_node;
extern char *current_dir;		// current directory displayed
extern gint tree_pos;			// count of exposed dirs from top
extern GtkCTreeNode *RootNode;  // root of all evil in tree

// local func protos
static GdkColor*	get_main_tooltips_bgcolor	();

// local data defs
static GtkWidget *cut_button, *copy_button, *paste_button;
static GtkWidget *remove_button, *rename_button;
//static GtkWidget *small_icons_button, *details_button;
static GtkWidget *prev_button, *next_button, *cdup_button;

// directory history
#define MAX_HISTORY 1000
GtkWidget *entry[MAX_HISTORY];
gint last_entry = 0, cur_entry = 0, direc = 0;

// ******************************
// dir_tree traversal support

void dir_entry_enter(GtkWidget *widget, GtkWidget *entry)
{
    struct stat st;
    char *txt;
    int n;

    txt=gtk_entry_get_text(GTK_ENTRY(entry));
    n=strlen(txt);

    // truncate terminating '/'
    if(txt[n-1]=='/' && n > 1)
        txt[n-1]='\0';

	// error if no access permissions
    if(access(txt, X_OK | R_OK)==-1) {
		gtk_entry_set_text(GTK_ENTRY(entry), current_dir);
		return;
    }
	// or cant stat 'txt'
    if(stat(txt, &st)==-1) {
		gtk_entry_set_text(GTK_ENTRY(entry), current_dir);
    }
    else
    	// or 'txt' is not a dir
    	if(!S_ISDIR(st.st_mode)) {
		gtk_entry_set_text(GTK_ENTRY(entry), current_dir);
    }
    else
    {	// we have a validated dir, process it
     	char target[256]="";
     	int cnt = 0, dst = 0;
     	int limit = strlen(txt);

     	// start 'txt' e.g. '/usr/local/bin
     	// first iteration searches for '/usr'
     	// second iteration searches for '/usr/local'
     	// third&final iteration searches for '/usr/local/bin'
     	while(cnt < limit){
     		target[dst++] = txt[cnt++];
     		// starting from the root, generate ever exanding paths
     		// until the displayed directory matches validated 'txt' string.
     		while(cnt < limit && 
     				(target[dst] = txt[cnt]) != '/' && 
     				txt[cnt])
     		{
     			dst++;
     			cnt++;
     		}
     		// find the specified path and expand that node in the dir_tree
     		tree_add_dir(target,FALSE);
     		free(current_dir);
     		current_dir = strdup (target);
     	}
     	// hilight the selected tree dir
     	if(dir_tree && current_dir_node) gtk_ctree_select(GTK_CTREE(dir_tree), current_dir_node);
     	// move tree dir viewport to show selected dir
     	gtk_ctree_node_moveto(GTK_CTREE(dir_tree), current_dir_node,0,0.25,0);
	}
}

void prev_dir(GtkWidget *widget, GtkWidget *aentry)
{
	if(cur_entry > 1 ) {
		char* txt;
		direc = 1;
		do{ // skip over dirs that have been rm'd
			txt=gtk_entry_get_text(GTK_ENTRY(entry[--cur_entry]));
		} while(cur_entry && (access(txt,F_OK)));
		dir_entry_enter(widget, entry[cur_entry]);
		direc = 0;
	}
}

void next_dir(GtkWidget *widget, GtkWidget *aentry)
{
	if(cur_entry < last_entry) {
		char* txt;
		direc = 1;
		do{ // skip over dirs that have been rm'd
			txt=gtk_entry_get_text(GTK_ENTRY(entry[++cur_entry]));
		} while((cur_entry < last_entry) && (access(txt,F_OK)));
		dir_entry_enter(widget, entry[cur_entry]);
		direc = 0;
	}
}

void change_to_dir(GtkWidget *widget, char *dir)
{
	GtkWidget *entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(entry), dir);
	dir_entry_enter(widget ? widget : (GtkWidget *)GTK_CTREE(dir_tree), entry);
}

void toolbar_cdup(GtkWidget *widget, gpointer data)
{
	char *parent_dir, *name;
	if(!(parent_dir = dir_parent_dir(current_dir, &name))) parent_dir = "/";
	change_to_dir(widget, parent_dir);
}

void
toolbar_prev_enable(gboolean e)
{
	gtk_widget_set_sensitive(prev_button, e);
}

void
toolbar_next_enable(gboolean e)
{
	gtk_widget_set_sensitive(next_button, e);
}

void
toolbar_cdup_enable(gboolean e)
{
	gtk_widget_set_sensitive(cdup_button, e);
}

/*
void
toolbar_remove_enable(gboolean e)
{
	gtk_widget_set_sensitive(remove_button, e);
}

void
toolbar_rename_enable(gboolean e)
{
	gtk_widget_set_sensitive(rename_button, e);
}

void
toolbar_cut_enable(gboolean e)
{
	gtk_widget_set_sensitive(cut_button, e);
}

void
toolbar_copy_enable(gboolean e)
{
	gtk_widget_set_sensitive(copy_button, e);
}

void
toolbar_paste_enable(gboolean e)
{
	gtk_widget_set_sensitive(paste_button, e);
}
*/

static GdkColor*
get_main_tooltips_bgcolor(GdkWindow *window, GdkColormap *colormap)
{
	static GdkColor color;
	static gboolean alloced = FALSE;
	if (!alloced)
	{
		color.red = 61669;
		color.green = 59113;
		color.blue = 35979;
		color.pixel = 0;
		gdk_color_alloc(colormap, &color);
		alloced = TRUE;
	}
	return &color;
}

GtkWidget*
get_main_toolbar(GtkWidget *parent)
{
	GtkWidget *toolbar, *pixmap_wid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	
	style = gtk_widget_get_style(parent);
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	gtk_tooltips_set_colors(
		GTK_TOOLBAR(toolbar)->tooltips,
		get_main_tooltips_bgcolor(parent->window, gdk_window_get_colormap(parent->window)),
		&style->fg[GTK_STATE_NORMAL]);
	gtk_tooltips_set_delay(GTK_TOOLBAR(toolbar)->tooltips, 100);

	// previous directory
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)goback_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);
	prev_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Prev Dir"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(prev_dir),
		NULL);

	// next directory
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)goforw_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);
	next_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Next Dir"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(next_dir),
		NULL);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	//up one directory
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)parent_folder_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);
	cdup_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("CD Up"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(toolbar_cdup),
		NULL);

	// refresh button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)refresh_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);
	gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Refresh"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(refreshlist),
		NULL);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	// Find button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)search_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	cut_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Find"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(search_show),
		NULL);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	// Cut button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)cut_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	cut_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Cut"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(selection_to_clipboard),
		NULL);

	// Copy button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)copy_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	copy_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Copy"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(selection_to_clipboard),
		NULL);

	// paste
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)paste_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	paste_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Paste"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(paste_clipboard),
		NULL);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	// delete button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)remove_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	remove_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Delete"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(delete_selection),
		NULL);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	// rename button
	pixmap = gdk_pixmap_create_from_xpm_d(
		parent->window,
		&mask, &style->bg[GTK_STATE_NORMAL],
		(gchar **)rename_xpm);
	pixmap_wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmap_wid);

	rename_button = gtk_toolbar_append_item(
		GTK_TOOLBAR(toolbar),
		NULL, _("Rename"), NULL,
		pixmap_wid,
		GTK_SIGNAL_FUNC(rename_selection),
		NULL);

	return toolbar;
}

/*
void
toolbar_set_list_type(ImageListType type)
{
	switch (type)
	{
	  case IMAGE_LIST_SMALL_ICONS:
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(small_icons_button), TRUE);
		break;
	  case IMAGE_LIST_DETAILS:
	  default:
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(details_button), TRUE);
		break;
	}
}
*/
