#include <gtk/gtk.h>
#include <string.h>

int answer;
GtkWidget *klik_neer;

extern void message (char *tekst);
extern gint question (char *text, gint num_buttons, char *button_text[]);
void question_button_clicked (GtkWidget *w, gpointer *data);
void message_ok (GtkWidget *w, gpointer *data);

/*
 * message is a function that shows a message to the user
 * it returns if the OK button has been pressed.
 * the gtk engine remains active, though.
 */

void message (char *tekst)
{
	GtkWidget *window, *label, *button, *vbox;

	window = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width (GTK_CONTAINER(window), 30);
	vbox = gtk_vbox_new(TRUE, 20);
	label = gtk_label_new (tekst);
	button  = gtk_button_new_with_label ("Ok");

	gtk_container_add (GTK_CONTAINER(window), vbox);
	gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);

	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC (message_ok), window);
	gtk_signal_connect (GTK_OBJECT(window), "delete_event",GTK_SIGNAL_FUNC (message_ok), window);
	gtk_signal_connect (GTK_OBJECT(window), "destroy",GTK_SIGNAL_FUNC (message_ok), window);


	gtk_widget_show_all (window);
	klik_neer = NULL;
	while(klik_neer != window) gtk_main_iteration();
	gtk_widget_destroy(window);
	klik_neer = NULL;
	return;
}

gint question (char *text, gint num_buttons, char *button_text[])
{
	GtkWidget *window, *label, *hbox, *vbox, *button;
	int i;
	window = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width (GTK_CONTAINER(window), 20);
	vbox = gtk_vbox_new(FALSE, 10);
	hbox = gtk_hbox_new (FALSE, 10);
	label = gtk_label_new (text);

	gtk_container_add (GTK_CONTAINER(window), vbox);
	gtk_box_pack_start (GTK_BOX(vbox), label, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC (question_button_clicked), (int)0);
/*	gtk_signal_connect (GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC (question_button_clicked), (int)0);
*/
	for (i=0;i<=num_buttons-1;i++) {
		button = gtk_button_new_with_label (*button_text);
		gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC (question_button_clicked), (gpointer)((int)i+1));
		gtk_box_pack_start (GTK_BOX(hbox), button, TRUE, TRUE, 10);
		gtk_widget_show(button);
		button_text++;
	}


	gtk_widget_show (label);
	gtk_widget_show (hbox);
	gtk_widget_show (vbox);
	gtk_widget_show (window);
	answer = 0;
	while (answer == 0) gtk_main_iteration ();
	gtk_widget_destroy(window);
	return answer;
}

void question_button_clicked (GtkWidget *w, gpointer *data)
{
	answer = (int)data;
}

void message_ok (GtkWidget *w, gpointer *data)
{
	klik_neer = (GtkWidget *)data;
}

gint verify_question ()
{
	char vtext[] = "Delete selected file(s)?";
	char *ync_text[] = { "Yes","No","Cancel"};
	return(question(vtext,3,ync_text));
}

