
/*
 * GTK See -- a image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "intl.h"

extern int SYSTEM (char *cmd);

static GtkWidget *file_spec_entry;
static GtkWidget *search_text_entry;
static GtkWidget *find_grep_options_entry;

static guchar old_file_spec[256];
static guchar old_search_string[256];
static guchar old_find_grep_options[256];

static void	search_done				(GtkWidget *window);
static void	find_now		(GtkWidget *widget, gpointer data);
static void	search_now	(GtkWidget *widget, gpointer data);

void
search_show()
{
	GtkWidget *window, *notebook, *label, *button;
	GtkWidget *frame, *vbox, *hbox;
	GtkAccelGroup *accel_group;
	guchar *buf = "";

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect_object(GTK_OBJECT(window), "delete_event",
		GTK_SIGNAL_FUNC(search_done), GTK_OBJECT(window));

	// Create and attach an accel group to the dialog window
	accel_group = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

	gtk_container_border_width(GTK_CONTAINER(window), 5);
	gtk_window_set_title(GTK_WINDOW(window), _("Search"));
	gtk_widget_realize(window);

	notebook = gtk_notebook_new();
	gtk_widget_show(notebook);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);

	/* Adding box frame : ---Files Named--- */

	frame = gtk_frame_new(_("Files Named"));
	gtk_container_border_width(GTK_CONTAINER(frame), 5);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 4);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 5);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	if(!file_spec_entry){
		file_spec_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(file_spec_entry), "*");
		old_file_spec[0] = '\0';
	} else {
		file_spec_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(file_spec_entry), old_file_spec);
	}

	gtk_box_pack_start(GTK_BOX(hbox), file_spec_entry, TRUE, TRUE, 2);
	gtk_widget_show(file_spec_entry);

	button = gtk_button_new_with_label(_(" Find "));
	gtk_signal_connect(GTK_OBJECT(button),
		"clicked",
		GTK_SIGNAL_FUNC(find_now),
		NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	gtk_widget_show(button);

	/* Adding box frame : ---Search For:--- */

	frame = gtk_frame_new(_("Search For:"));
	gtk_container_border_width(GTK_CONTAINER(frame), 5);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 4);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 5);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	if(!search_text_entry){
		search_text_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(search_text_entry), "");
		old_search_string[0] = '\0';
	} else {
		search_text_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(search_text_entry), old_search_string);
	}

	gtk_box_pack_start(GTK_BOX(hbox), search_text_entry, TRUE, TRUE, 2);
	gtk_widget_show(search_text_entry);

	button = gtk_button_new_with_label(_("Search"));
	gtk_signal_connect(GTK_OBJECT(button),
		"clicked",
		GTK_SIGNAL_FUNC(search_now),
		NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	gtk_widget_show(button);

	/* Adding box frame : ---Find/Grep Options--- */

	frame = gtk_frame_new(_("Find/Grep Options"));
	gtk_container_border_width(GTK_CONTAINER(frame), 5);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 4);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	if(!find_grep_options_entry){
		find_grep_options_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(find_grep_options_entry), buf);
		old_find_grep_options[0] = '\0';
	} else {
		find_grep_options_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(find_grep_options_entry), old_find_grep_options);
	}
	gtk_box_pack_start(GTK_BOX(hbox), find_grep_options_entry,TRUE, TRUE, 2);

	gtk_widget_show(find_grep_options_entry);

	label = gtk_label_new(_("Find/Search"));
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox, label);

	// Creating Done button
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	button = gtk_button_new_with_label(_(" Done "));
	gtk_signal_connect_object(GTK_OBJECT(button),
		"clicked",
		GTK_SIGNAL_FUNC(search_done),
		GTK_OBJECT(window));
	gtk_widget_add_accelerator(button, "clicked", accel_group,
								GDK_Escape, 0, GTK_ACCEL_LOCKED);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 4);

	/* finally, add notebook and buttons to window... */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 10);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 10);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	gtk_grab_add(window);
	gtk_widget_set_usize(window, 400, 300);
	gtk_widget_grab_focus(GTK_WIDGET(search_text_entry));

	gtk_widget_show(window);
}

static void
search_done(GtkWidget *window)
{
	strcpy(old_file_spec, gtk_entry_get_text(GTK_ENTRY(file_spec_entry)));
	strcpy(old_search_string, gtk_entry_get_text(GTK_ENTRY(search_text_entry)));
	strcpy(old_find_grep_options, gtk_entry_get_text(GTK_ENTRY(find_grep_options_entry)));
	gtk_grab_remove(window);
	gtk_widget_destroy(window);
}

static void
find_now(GtkWidget *widget, gpointer data)
{
	char    cmdstr[512];
	sprintf(cmdstr,"find . -iname '%s' %s -fprint fl.lst 2>> fl.lst;edx fl.lst;sleep 1;rm fl.lst",
	        gtk_entry_get_text(GTK_ENTRY(file_spec_entry)),
	        gtk_entry_get_text(GTK_ENTRY(find_grep_options_entry)));
//printf("Find now:%s.\n",cmdstr);
	SYSTEM(cmdstr);
}

static void
search_now(GtkWidget *widget, gpointer data)
{
	char    cmdstr[512];
	sprintf(cmdstr,"grep -Insr %s %s %s > fl.lst 2>> fl.lst;edx fl.lst;sleep 1;rm fl.lst",
	        gtk_entry_get_text(GTK_ENTRY(search_text_entry)),
	        gtk_entry_get_text(GTK_ENTRY(file_spec_entry)),
	        gtk_entry_get_text(GTK_ENTRY(find_grep_options_entry)));
//printf("Search now:%s.\n",cmdstr);
	SYSTEM(cmdstr);
}
